/*
 * Decompiled with CFR 0.152.
 */
package com.jeequan.jeepay.net;

import com.alibaba.fastjson.JSON;
import com.jeequan.jeepay.exception.APIConnectionException;
import com.jeequan.jeepay.exception.JeepayException;
import com.jeequan.jeepay.net.APIJeepayRequest;
import com.jeequan.jeepay.net.APIJeepayResponse;
import java.net.ConnectException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;

public abstract class HttpClient {
    public static final long maxNetworkRetriesDelay = 5000L;
    public static final long minNetworkRetriesDelay = 500L;
    boolean networkRetriesSleep = true;

    public abstract APIJeepayResponse request(APIJeepayRequest var1) throws JeepayException;

    public APIJeepayResponse requestWithRetries(APIJeepayRequest request) throws JeepayException {
        APIConnectionException requestException = null;
        APIJeepayResponse response = null;
        int retry = 0;
        while (true) {
            requestException = null;
            try {
                response = this.request(request);
            }
            catch (APIConnectionException e) {
                requestException = e;
            }
            if (!this.shouldRetry(retry, requestException, request, response)) break;
            ++retry;
            try {
                Thread.sleep(this.sleepTime(retry));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (requestException != null) {
            throw requestException;
        }
        response.setNumRetries(retry);
        return response;
    }

    protected static String buildUserAgentString(String version) {
        return String.format("Jeepay/v1 JavaBindings/%s", version);
    }

    protected static String buildXJeepayClientUserAgentString(String version) {
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("bindings.version", version);
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Jeepay");
        return JSON.toJSONString(propertyMap);
    }

    private boolean shouldRetry(int numRetries, JeepayException exception, APIJeepayRequest request, APIJeepayResponse response) {
        if (numRetries >= request.options.getMaxNetworkRetries()) {
            return false;
        }
        if (exception != null && exception.getCause() != null && exception.getCause() instanceof ConnectException) {
            return true;
        }
        return response != null && response.getResponseCode() >= 500;
    }

    private long sleepTime(int numRetries) {
        double jitter;
        if (!this.networkRetriesSleep) {
            return 0L;
        }
        long delay = (long)(500.0 * Math.pow(2.0, numRetries - 1));
        if (delay > 5000L) {
            delay = 5000L;
        }
        if ((delay = (long)((double)delay * (jitter = ThreadLocalRandom.current().nextDouble(0.75, 1.0)))) < 500L) {
            delay = 500L;
        }
        return delay;
    }

    private static String getRequestURIFromURL(URL url) {
        String path = url.getPath();
        String query = url.getQuery();
        if (query == null) {
            return path;
        }
        return path + "?" + query;
    }
}

