/*
 * Decompiled with CFR 0.152.
 */
package com.jushuitan.api;

import com.jushuitan.api.util.ApiUtil;
import java.io.Serializable;

public class ApiRequest
implements Serializable {
    private static final long serialVersionUID = 5637431981455538000L;
    private String url;
    private String appSecret;
    private String appKey;
    private String biz;

    private ApiRequest(Builder builder) {
        this.url = builder.url;
        this.appSecret = builder.appSecret;
        this.appKey = builder.appKey;
        this.biz = builder.biz;
    }

    public Boolean isValid() {
        if (ApiUtil.isEmpty(this.url) || ApiUtil.isEmpty(this.appSecret) || ApiUtil.isEmpty(this.appKey)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getUrl() {
        return this.url;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getBiz() {
        return this.biz;
    }

    public static final class Builder {
        private String url;
        private String appSecret;
        private String appKey;
        private String biz;

        public Builder(String url, String appKey, String appSecret) {
            this.url = url;
            this.appSecret = appSecret;
            this.appKey = appKey;
        }

        public Builder biz(String biz) {
            this.biz = biz;
            return this;
        }

        public ApiRequest build() {
            return new ApiRequest(this);
        }
    }
}

