/*
 * Decompiled with CFR 0.152.
 */
package com.jushuitan.api;

import com.jushuitan.api.util.ApiUtil;
import java.io.Serializable;

public class AuthRequest
implements Serializable {
    private static final long serialVersionUID = 1122228998377363869L;
    private String appSecret;
    private String appKey;
    private String state;
    private String code;
    private String refreshToken;

    private AuthRequest(Builder builder) {
        this.appSecret = builder.appSecret;
        this.appKey = builder.appKey;
        this.code = builder.code;
        this.state = builder.state;
        this.refreshToken = builder.refreshToken;
    }

    public Boolean isValid() {
        if (ApiUtil.isEmpty(this.appSecret) || ApiUtil.isEmpty(this.appKey)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getState() {
        return this.state;
    }

    public String getCode() {
        return this.code;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public static final class Builder {
        private String appSecret;
        private String appKey;
        private String state;
        private String code;
        private String refreshToken;

        public Builder(String appKey, String appSecret) {
            this.appSecret = appSecret;
            this.appKey = appKey;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public AuthRequest build() {
            return new AuthRequest(this);
        }
    }
}

