/*
 * Decompiled with CFR 0.152.
 */
package com.jushuitan.api;

import com.jushuitan.api.ApiClient;
import com.jushuitan.api.ApiCodeEnum;
import com.jushuitan.api.ApiRequest;
import com.jushuitan.api.ApiResponse;
import com.jushuitan.api.exception.ApiException;
import com.jushuitan.api.util.ApiUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class DefaultApiClient
implements ApiClient {
    public static final String VERSION = "2";
    public static final String CHARSET_UTF8 = "utf-8";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    public static final String METHOD_POST = "POST";
    private int connectTimeout = 2000;
    private int readTimeout = 40000;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public ApiResponse execute(ApiRequest request, String accessToken) throws ApiException {
        ApiResponse response;
        if (null != request && request.isValid().booleanValue()) {
            HashMap<String, String> params = new HashMap<String, String>();
            String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
            params.put("app_key", request.getAppKey());
            params.put("access_token", accessToken);
            params.put("timestamp", timestamp);
            params.put("version", VERSION);
            params.put("charset", CHARSET_UTF8);
            params.put("biz", request.getBiz());
            String sign = ApiUtil.getSign(request.getAppSecret(), params);
            params.put("sign", sign);
            try {
                response = this.executeRemote(request, params);
            }
            catch (SocketTimeoutException e) {
                throw new ApiException(ApiCodeEnum.TIME_OUT_ERROR);
            }
            catch (ConnectException e) {
                throw new ApiException(ApiCodeEnum.CONNECT_ERROR);
            }
            catch (IOException e) {
                throw new ApiException(ApiCodeEnum.EXECUTE_ERROR);
            }
            catch (Exception e) {
                throw new ApiException(ApiCodeEnum.SYS_ERROR);
            }
        } else {
            throw new ApiException(ApiCodeEnum.PARAM_ERROR);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApiResponse executeRemote(ApiRequest request, Map<String, String> params) throws IOException, ApiException {
        String query = this.buildQuery(params, CHARSET_UTF8);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(CHARSET_UTF8);
        }
        URL url = new URL(request.getUrl());
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(METHOD_POST);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setConnectTimeout(this.connectTimeout);
            conn.setReadTimeout(this.readTimeout);
            conn.setRequestProperty("open-source", "sdk");
            conn.setRequestProperty("Host", url.getHost());
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            out = conn.getOutputStream();
            out.write(content);
            ApiResponse apiResponse = this.getResponseAsString(conn);
            return apiResponse;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (ApiUtil.isEmpty(name) || ApiUtil.isEmpty(value)) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    private ApiResponse getResponseAsString(HttpURLConnection conn) throws IOException {
        ApiResponse response = new ApiResponse();
        String charset = CHARSET_UTF8;
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(contentEncoding)) {
                response.setBody(this.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset));
            } else {
                response.setBody(this.getStreamAsString(conn.getInputStream(), charset));
            }
        } else {
            response.setCode(conn.getResponseCode());
            response.setMsg(conn.getResponseMessage());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

