/*
 * Decompiled with CFR 0.152.
 */
package com.jushuitan.api.util;

import com.jushuitan.api.ApiCodeEnum;
import com.jushuitan.api.exception.ApiException;
import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeSet;

public class ApiUtil {
    private ApiUtil() {
    }

    public static String getSign(String signKey, Map<String, String> params) {
        String sortedStr = ApiUtil.getSortedParamStr(params);
        String paraStr = signKey + sortedStr;
        return ApiUtil.createSign(paraStr);
    }

    public static String getSortedParamStr(Map<String, String> params) {
        TreeSet<String> sortedParams = new TreeSet<String>(params.keySet());
        StringBuilder strB = new StringBuilder();
        for (String key : sortedParams) {
            String value;
            if ("sign".equalsIgnoreCase(key) || ApiUtil.isEmpty(value = params.get(key))) continue;
            strB.append(key).append(value);
        }
        return strB.toString();
    }

    public static String createSign(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(str.getBytes("UTF-8"));
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                buf[k++] = hexDigits[byte0 >>> 4 & 0xF];
                buf[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(buf);
        }
        catch (Exception e) {
            throw new ApiException(ApiCodeEnum.SIGN_ERROR);
        }
    }

    public static boolean isEmpty(String str) {
        return null == str || "".equals(str);
    }
}

