/*
 * Decompiled with CFR 0.152.
 */
package com.jushuitan.api.util;

import com.jushuitan.api.ApiCodeEnum;
import com.jushuitan.api.ApiResponse;
import com.jushuitan.api.AuthRequest;
import com.jushuitan.api.exception.ApiException;
import com.jushuitan.api.util.ApiUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class AuthUtil {
    static final String AUTH_URL = "https://openweb.jushuitan.com/auth";
    static final String ACCESS_TOKEN_URL = "https://openapi.jushuitan.com/openWeb/auth/accessToken";
    static final String REFRESH_TOKEN_URL = "https://openapi.jushuitan.com/openWeb/auth/refreshToken";
    static final String INIT_TOKEN_URL = "https://openapi.jushuitan.com/openWeb/auth/getInitToken";
    static final String CHARSET_UTF8 = "utf-8";
    static final String GRANT_TYPE_AUTH_CODE = "authorization_code";
    static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    static final String SCOPE_DEFAULT = "all";
    static final String CONTENT_ENCODING_GZIP = "gzip";
    static final String METHOD_POST = "POST";

    private AuthUtil() {
    }

    public static String getAuthUrl(AuthRequest request) {
        if (null == request || !request.isValid().booleanValue()) {
            throw new ApiException(ApiCodeEnum.PARAM_ERROR);
        }
        StringBuffer url = new StringBuffer("https://openweb.jushuitan.com/auth?");
        HashMap<String, String> params = new HashMap<String, String>();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        params.put("app_key", request.getAppKey());
        params.put("timestamp", timestamp);
        params.put("charset", CHARSET_UTF8);
        if (!ApiUtil.isEmpty(request.getState())) {
            params.put("state", request.getState());
        }
        String sign = ApiUtil.getSign(request.getAppSecret(), params);
        params.put("sign", sign);
        int index = 0;
        for (String key : params.keySet()) {
            if (params.size() - 1 == index) {
                url.append(key).append("=").append((String)params.get(key));
            } else {
                url.append(key).append("=").append((String)params.get(key)).append("&");
            }
            ++index;
        }
        return url.toString();
    }

    public static String getAccessToken(AuthRequest request) throws IOException, ApiException {
        if (null == request || !request.isValid().booleanValue() || ApiUtil.isEmpty(request.getCode())) {
            throw new ApiException(ApiCodeEnum.PARAM_ERROR);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        params.put("app_key", request.getAppKey());
        params.put("timestamp", timestamp);
        params.put("charset", CHARSET_UTF8);
        params.put("grant_type", GRANT_TYPE_AUTH_CODE);
        params.put("code", request.getCode());
        String sign = ApiUtil.getSign(request.getAppSecret(), params);
        params.put("sign", sign);
        return AuthUtil.executeRemote(ACCESS_TOKEN_URL, params);
    }

    public static String refreshToken(AuthRequest request) throws IOException, ApiException {
        if (null == request || !request.isValid().booleanValue() || ApiUtil.isEmpty(request.getRefreshToken())) {
            throw new ApiException(ApiCodeEnum.PARAM_ERROR);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        params.put("app_key", request.getAppKey());
        params.put("timestamp", timestamp);
        params.put("charset", CHARSET_UTF8);
        params.put("grant_type", GRANT_TYPE_REFRESH_TOKEN);
        params.put("scope", SCOPE_DEFAULT);
        params.put(GRANT_TYPE_REFRESH_TOKEN, request.getRefreshToken());
        String sign = ApiUtil.getSign(request.getAppSecret(), params);
        params.put("sign", sign);
        return AuthUtil.executeRemote(REFRESH_TOKEN_URL, params);
    }

    public static String getInitToken(AuthRequest request) throws IOException, ApiException {
        if (null == request || !request.isValid().booleanValue() || ApiUtil.isEmpty(request.getCode())) {
            throw new ApiException(ApiCodeEnum.PARAM_ERROR);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        params.put("app_key", request.getAppKey());
        params.put("timestamp", timestamp);
        params.put("charset", CHARSET_UTF8);
        params.put("grant_type", GRANT_TYPE_AUTH_CODE);
        params.put("code", request.getCode());
        String sign = ApiUtil.getSign(request.getAppSecret(), params);
        params.put("sign", sign);
        return AuthUtil.executeRemote(INIT_TOKEN_URL, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String executeRemote(String requestUrl, Map<String, String> params) throws IOException, ApiException {
        String query = AuthUtil.buildQuery(params, CHARSET_UTF8);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(CHARSET_UTF8);
        }
        URL url = new URL(requestUrl);
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(METHOD_POST);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("open-source", "sdk");
            conn.setRequestProperty("Host", url.getHost());
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            out = conn.getOutputStream();
            out.write(content);
            String string = AuthUtil.getResponseAsString(conn);
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (ApiUtil.isEmpty(name) || ApiUtil.isEmpty(value)) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    private static String getResponseAsString(HttpURLConnection conn) throws IOException {
        ApiResponse response = new ApiResponse();
        String charset = CHARSET_UTF8;
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if (CONTENT_ENCODING_GZIP.equalsIgnoreCase(contentEncoding)) {
                return AuthUtil.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return AuthUtil.getStreamAsString(conn.getInputStream(), charset);
        }
        throw new ApiException(ApiCodeEnum.EXECUTE_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

