/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk;

import com.lop.open.api.sdk.LopException;
import com.lop.open.api.sdk.commons.HttpContentType;
import com.lop.open.api.sdk.internal.fastjson.JSONObject;
import com.lop.open.api.sdk.internal.parser.Parser;
import com.lop.open.api.sdk.internal.parser.ParserFactory;
import com.lop.open.api.sdk.internal.util.HttpUtil;
import com.lop.open.api.sdk.internal.util.StringUtil;
import com.lop.open.api.sdk.plugin.LopPlugin;
import com.lop.open.api.sdk.plugin.encry.RSAUtil;
import com.lop.open.api.sdk.plugin.entity.OAuth2Plugin;
import com.lop.open.api.sdk.plugin.entity.RsaCipherPlugin;
import com.lop.open.api.sdk.plugin.factory.OAuth2PluginFactory;
import com.lop.open.api.sdk.request.DomainAbstractRequest;
import com.lop.open.api.sdk.request.DomainFileAbstractRequest;
import com.lop.open.api.sdk.request.DomainHttpParam;
import com.lop.open.api.sdk.request.info.HttpPostInfo;
import com.lop.open.api.sdk.response.AbstractResponse;
import com.lop.open.api.sdk.util.DomainApiUtil;
import java.io.IOException;
import java.net.Proxy;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class DefaultDomainApiClient {
    public static final String CHARSET_UTF8 = "UTF-8";
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private String serverUrl;
    private Proxy proxy = null;

    public DefaultDomainApiClient(String serverUrl, int connectTimeout, int readTimeout) {
        this.serverUrl = serverUrl;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultDomainApiClient(String serverUrl, int connectTimeout, int readTimeout, Proxy proxy) {
        this.serverUrl = serverUrl;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.proxy = proxy;
    }

    public DefaultDomainApiClient(String serverUrl, Proxy proxy) {
        this.serverUrl = serverUrl;
        this.proxy = proxy;
    }

    public DefaultDomainApiClient(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public <T extends AbstractResponse> T execute(DomainAbstractRequest<T> request) throws LopException {
        try {
            T resp = this.executeDelegate(request);
            if (resp != null && OAuth2PluginFactory.isAccessTokenExpired(((AbstractResponse)resp).getCode())) {
                return this.refreshAccessTokenExpireTimeAndRepeatExecute(request);
            }
            return resp;
        }
        catch (Exception e) {
            throw new LopException(e);
        }
    }

    private <T extends AbstractResponse> T executeDelegate(DomainAbstractRequest<T> request) throws Exception {
        DomainHttpParam httpParam = request.buildDomainHttpParam(this);
        String bodyContent = httpParam.getBodyContent();
        boolean httpDomainApi = DomainApiUtil.isHttpDomainApi(request.getDomainApiTypeCode());
        if (httpDomainApi) {
            bodyContent = DomainApiUtil.buildHttpBodyObjectsJson(request.getBodyObject(), HttpContentType.APPLICATION_JSON);
        }
        byte[] bodyContentBytes = bodyContent.getBytes(CHARSET_UTF8);
        HttpPostInfo postInfo = new HttpPostInfo.Builder().setConnectTimeout(this.connectTimeout).setReadTimeout(this.readTimeout).setUrl(this.getRequestUrl(httpParam)).setHeadParams(httpParam.getHeaders()).setBody(bodyContentBytes).setProxy(this.proxy != null ? this.proxy : null).setUseJosAuth(request.getUseJosAuth()).instance();
        String rsp = HttpUtil.doPost(postInfo);
        if (rsp.indexOf("error_response") < 0) {
            List<LopPlugin> pluginList = request.getLopPluginList();
            for (LopPlugin plugin : pluginList) {
                RsaCipherPlugin cipherPlugin;
                if (!(plugin instanceof RsaCipherPlugin) || !(cipherPlugin = (RsaCipherPlugin)plugin).getRepoonseCipher()) continue;
                rsp = new String(RSAUtil.decryptByKeyIv(Base64.decodeBase64((String)rsp), cipherPlugin.getKeyRandom().getBytes(), cipherPlugin.getIvRandom().getBytes()));
            }
            if (rsp.isEmpty()) {
                rsp = "\"\"";
            }
            rsp = "{\"response\":{\"content\":" + rsp + ", \"code\":0}}";
        }
        T resp = this.parse(rsp, request.getResponseClass());
        return resp;
    }

    private <T extends AbstractResponse> T refreshAccessTokenExpireTimeAndRepeatExecute(DomainAbstractRequest<T> request) throws LopException {
        List<LopPlugin> pluginList = request.getLopPluginList();
        if (pluginList != null && pluginList.size() > 0) {
            for (LopPlugin lopPlugin : pluginList) {
                if (!(lopPlugin instanceof OAuth2Plugin)) continue;
                OAuth2Plugin oAuth2Plugin = (OAuth2Plugin)lopPlugin;
                OAuth2PluginFactory.clearAccessToken(oAuth2Plugin.getRefreshToken());
                OAuth2PluginFactory.produceLopPlugin(this, oAuth2Plugin);
                try {
                    return this.executeDelegate(request);
                }
                catch (Exception e) {
                    throw new LopException(e);
                }
            }
        }
        return null;
    }

    @Deprecated
    public <T extends AbstractResponse> T uploadFile(DomainFileAbstractRequest<T> request) throws LopException {
        return this.uploadFiles(request);
    }

    public <T extends AbstractResponse> T uploadFiles(DomainFileAbstractRequest<T> request) throws LopException {
        try {
            DomainHttpParam httpParam = request.buildDomainHttpParam(this);
            HttpPostInfo postInfo = new HttpPostInfo.Builder().setConnectTimeout(this.connectTimeout).setReadTimeout(this.readTimeout).setUrl(this.getRequestUrl(httpParam)).setHeadParams(httpParam.getHeaders()).setProxy(this.proxy != null ? this.proxy : null).instance();
            String rsp = HttpUtil.doUploadFiles(postInfo, request.getFileList());
            if (rsp.indexOf("error_response") < 0) {
                JSONObject jsonObject = JSONObject.parseObject(rsp);
                rsp = "{\"response\":" + rsp + ",\"code\":" + jsonObject.getString("code") + "}";
            }
            T resp = this.parse(rsp, request.getResponseClass());
            return resp;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LopException(e);
        }
    }

    public void downloadFile(DomainFileAbstractRequest request) throws LopException {
        try {
            DomainHttpParam httpParam = request.buildDomainHttpParam(this);
            HttpPostInfo postInfo = new HttpPostInfo.Builder().setConnectTimeout(this.connectTimeout).setReadTimeout(this.readTimeout).setUrl(this.getRequestUrl(httpParam)).setHeadParams(httpParam.getHeaders()).setProxy(this.proxy != null ? this.proxy : null).instance();
            HttpUtil.doDownloadFile(postInfo, request.getFileList().get(0));
        }
        catch (Exception e) {
            throw new LopException(e);
        }
    }

    private String getRequestUrl(DomainHttpParam httpParam) throws IOException {
        StringBuilder url = new StringBuilder(this.serverUrl);
        if (StringUtil.areNotEmpty(httpParam.getUrlPath())) {
            url.append(httpParam.getUrlPath());
        }
        if (StringUtil.areNotEmpty(httpParam.getUrlArgsQuery())) {
            url.append("?");
            url.append(httpParam.getUrlArgsQuery());
        }
        return url.toString();
    }

    private <T extends AbstractResponse> T parse(String rsp, Class<T> responseClass) throws LopException {
        Parser parser = ParserFactory.getJsonParser();
        return parser.parse(rsp, responseClass);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public Proxy getProxy() {
        return this.proxy;
    }
}

