/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk;

import com.lop.open.api.sdk.LopException;
import com.lop.open.api.sdk.TokenClient;
import com.lop.open.api.sdk.internal.fastjson.JSONObject;
import com.lop.open.api.sdk.internal.util.CodecUtil;
import com.lop.open.api.sdk.internal.util.HttpUtil;
import com.lop.open.api.sdk.internal.util.JsonUtil;
import com.lop.open.api.sdk.internal.util.StringUtil;
import com.lop.open.api.sdk.request.DomainRequest;
import com.lop.open.api.sdk.request.info.HttpPostInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class DefaultDomainClient {
    public static final String CHARSET_UTF8 = "UTF-8";
    private static final String JSON_PARAM_KEY = "param_json";
    private static final String URL_SEPARATOR = "/";
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private boolean initialized;
    private String serverUrl;
    private String domain;
    private String appKey;
    private String appSecret;
    private String accessToken;
    private String refreshToken;
    private String method;
    private TokenClient tokenClient;

    public DefaultDomainClient(String serverUrl, String domain, int connectTimeout, int readTimeout) {
        this.serverUrl = serverUrl;
        this.domain = domain;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultDomainClient(String serverUrl, String domain, String appKey, String appSecret, String refreshToken) {
        this.serverUrl = serverUrl;
        this.domain = domain;
        this.appKey = appKey;
        this.refreshToken = refreshToken;
        this.appSecret = appSecret;
    }

    public void init() throws LopException {
        if (StringUtil.isEmpty(this.serverUrl)) {
            throw new LopException("serverUrl can not be null");
        }
        StringBuilder baseUrl = new StringBuilder(100);
        try {
            String path;
            URL url = new URL(this.serverUrl);
            String host = url.getHost();
            if (StringUtil.isEmpty(host)) {
                throw new LopException("invalid serverUrl:" + this.serverUrl);
            }
            baseUrl.append(url.getProtocol()).append("://").append(host);
            if (!"-1".equals(url.getPort())) {
                baseUrl.append(":").append(url.getPort());
            }
            if (StringUtil.isEmpty(path = url.getPath()) || URL_SEPARATOR.equals(path)) {
                throw new LopException("url path is null");
            }
            this.method = path;
            this.serverUrl = baseUrl.toString() + path;
        }
        catch (MalformedURLException e) {
            throw new LopException(e);
        }
        this.tokenClient = new TokenClient(baseUrl.toString(), this.appKey, this.appSecret);
        this.accessToken = this.tokenClient.getRefreshToken(this.refreshToken);
        this.initialized = true;
    }

    public DefaultDomainClient(String serverUrl, String domain, String appKey, String appSecret, String accessToken, int connectTimeout, int readTimeout) {
        this(serverUrl, domain, appKey, appSecret, accessToken);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public String execute(DomainRequest domainRequest) throws LopException {
        if (!this.initialized) {
            throw new LopException("client not init");
        }
        String resp = this.execute1(domainRequest);
        return resp;
    }

    private String execute1(DomainRequest request) throws LopException {
        try {
            String url = this.buildUrl(request);
            HashMap<String, String> headParams = new HashMap<String, String>();
            String json = JsonUtil.toJson(request.getBody());
            headParams.put(JSON_PARAM_KEY, json);
            HttpPostInfo postInfo = new HttpPostInfo.Builder().setConnectTimeout(this.connectTimeout).setReadTimeout(this.readTimeout).setUrl(url).setHeadParams(headParams).instance();
            String rsp = HttpUtil.doPost(postInfo);
            return rsp;
        }
        catch (Exception e) {
            throw new LopException(e);
        }
    }

    private String buildUrl(DomainRequest request) throws Exception {
        StringBuilder sb = new StringBuilder(this.serverUrl);
        sb.append("?");
        TreeMap<String, String> sysParams = new TreeMap<String, String>();
        TreeMap<String, String> pmap = new TreeMap<String, String>();
        pmap.put(JSON_PARAM_KEY, JsonUtil.toJson(request.getBody()));
        sysParams.put("method", this.method);
        sysParams.put("access_token", this.accessToken);
        sysParams.put("app_key", this.appKey);
        sysParams.put("timestamp", request.getTimestamp());
        sysParams.put("v", request.getVersion());
        pmap.putAll(sysParams);
        String signResult = this.sign(pmap, this.appSecret);
        request.addUrlArg("LOP-DN", this.domain);
        request.addUrlArg("sign", signResult);
        request.addUrlArg(pmap);
        sb.append(HttpUtil.buildQuery(request.getUrlArgs(), CHARSET_UTF8));
        return sb.toString();
    }

    private String sign(Map<String, String> pmap, String appSecret) throws Exception {
        StringBuilder sb = new StringBuilder(appSecret);
        for (Map.Entry<String, String> entry : pmap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StringUtil.areNotEmpty(name, value)) continue;
            sb.append(name).append(value);
        }
        sb.append(appSecret);
        String result = CodecUtil.md5(sb.toString());
        return result;
    }

    public static void main(String[] args) {
        DefaultDomainClient client = new DefaultDomainClient("http://test-proxy.jd.com/testSensField", "test.jlop.com", "2530e1fa591240368a43e9557489c0dd", "11a361f91dfe48a39a2ad80c08bb3592", "a091088ea69a45d28a0852df0ff34307");
        try {
            client.init();
            DomainRequest domainRequest = new DomainRequest();
            JSONObject t = new JSONObject();
            t.put("name", (Object)"tname");
            t.put("userPin", (Object)"tuserpin");
            t.put("pin", (Object)"tpin");
            domainRequest.addBody(t);
            String string = client.execute(domainRequest);
        }
        catch (LopException e) {
            e.printStackTrace();
        }
    }
}

