/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk;

import com.lop.open.api.sdk.DefaultDomainApiClient;
import com.lop.open.api.sdk.LopException;
import com.lop.open.api.sdk.plugin.LopPlugin;
import com.lop.open.api.sdk.plugin.factory.OAuth2PluginFactory;
import com.lop.open.api.sdk.request.DomainAbstractRequest;
import com.lop.open.api.sdk.response.AbstractResponse;

public class JdlClient {
    DefaultDomainApiClient defaultDomainApiClient;
    private int connectTimeout = 500;
    private int readTimeout = 15000;
    LopPlugin lopPlugin;

    public JdlClient(String serverUrl, String appKey, String appSecret, String accessToken) {
        this.defaultDomainApiClient = new DefaultDomainApiClient(serverUrl, this.connectTimeout, this.readTimeout);
        this.lopPlugin = OAuth2PluginFactory.produceLopPlugin(appKey, appSecret, accessToken);
    }

    public JdlClient(String serverUrl, String appKey, String appSecret, String accessToken, int connectTimeout, int readTimeout) {
        this.defaultDomainApiClient = new DefaultDomainApiClient(serverUrl, connectTimeout, readTimeout);
        this.lopPlugin = OAuth2PluginFactory.produceLopPlugin(appKey, appSecret, accessToken);
    }

    public <T extends AbstractResponse> T execute(DomainAbstractRequest<T> request) throws LopException {
        request.addLopPlugin(this.lopPlugin);
        return this.defaultDomainApiClient.execute(request);
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeout = connectTimeOut;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

