/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class HttpFileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream writeFile(File file, OutputStream out) throws Exception {
        try (FileInputStream instream = new FileInputStream(file);){
            int l;
            byte[] tmp = new byte[4096];
            while ((l = instream.read(tmp)) != -1) {
                out.write(tmp, 0, l);
            }
            out.flush();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFiles(DataOutputStream dsOut, List<File> uploadFileList, String boundary) throws Exception {
        String end = "\r\n";
        String twoHyphens = "--";
        int index = 0;
        for (File uploadFile : uploadFileList) {
            String filename = uploadFile.getName();
            dsOut.writeBytes(twoHyphens + boundary + end);
            dsOut.writeBytes("Content-Disposition: form-data; name=\"file" + index++ + "\";filename=\"" + filename + "\"" + end);
            dsOut.writeBytes(end);
            FileInputStream fStream = null;
            try {
                fStream = new FileInputStream(uploadFile);
                int bufferSize = 1024;
                byte[] buffer = new byte[bufferSize];
                int length = -1;
                while ((length = fStream.read(buffer)) != -1) {
                    dsOut.write(buffer, 0, length);
                }
                dsOut.writeBytes(end);
            }
            finally {
                if (fStream == null) continue;
                fStream.close();
            }
        }
        dsOut.writeBytes(twoHyphens + boundary + twoHyphens + end);
        dsOut.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(File file, InputStream input) throws Exception {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        OutputStream fileOut = null;
        BufferedInputStream fileInput = null;
        try {
            fileInput = new BufferedInputStream(input);
            fileOut = new BufferedOutputStream(new FileOutputStream(file));
            int size = 0;
            int len = 0;
            byte[] buf = new byte[1024];
            while ((size = fileInput.read(buf)) != -1) {
                len += size;
                fileOut.write(buf, 0, size);
            }
        }
        finally {
            if (fileOut != null) {
                fileOut.close();
            }
            if (fileInput != null) {
                fileInput.close();
            }
        }
    }
}

