/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.internal.util;

import com.lop.open.api.sdk.internal.util.DefaultTrustManager;
import com.lop.open.api.sdk.internal.util.HttpFileUtil;
import com.lop.open.api.sdk.internal.util.StringUtil;
import com.lop.open.api.sdk.request.info.ConnectionInfo;
import com.lop.open.api.sdk.request.info.HttpPostInfo;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;

public class HttpUtil {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final String DEFAULT_COMPRESS_TYPE = "gzip";
    private static final int DEFAULT_GZIP_MIN_LENGTH = 102400;
    public static final String SDK_VERSION = "2.0";

    private HttpUtil() {
        throw new UnsupportedOperationException();
    }

    public static String buildQuery(Map<String, String> params, String charset) throws Exception {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtil.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    public static String buildQueryJson(Map<String, String> params, String charset) throws Exception {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            query.append(value);
        }
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String doPost(String url, Map<String, String> headers, byte[] content, int connectTimeout, int readTimeout) throws Exception {
        String ctype = "application/json;charset=UTF-8";
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            boolean needCompression = HttpUtil.isNeedCompression(content);
            conn = HttpUtil.getConnection(HttpUtil.createConnectionInfo(url, METHOD_POST, ctype, null));
            HttpUtil.supplyHttpHeaders(conn, headers);
            if (needCompression) {
                conn.setRequestProperty("Content-Encoding", DEFAULT_COMPRESS_TYPE);
            }
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = HttpUtil.getHttpOutputStream(needCompression, out, conn, content);
            rsp = HttpUtil.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(HttpPostInfo postInfo) throws Exception {
        String ctype = "application/json;charset=UTF-8";
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            boolean needCompression = HttpUtil.isNeedCompression(postInfo.getBody());
            conn = HttpUtil.getConnection(HttpUtil.createConnectionInfo(postInfo.getUrl(), METHOD_POST, ctype, postInfo.getProxy()));
            HttpUtil.supplyHttpHeaders(conn, postInfo.getHeadParams());
            if (needCompression) {
                conn.setRequestProperty("Content-Encoding", DEFAULT_COMPRESS_TYPE);
            }
            if (postInfo.getUseJosAuth()) {
                conn.setRequestProperty("X-UseJosAuth", "true");
            }
            conn.setConnectTimeout(postInfo.getConnectTimeout());
            conn.setReadTimeout(postInfo.getReadTimeout());
            out = HttpUtil.getHttpOutputStream(needCompression, out, conn, postInfo.getBody());
            rsp = HttpUtil.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostNoHeadersParam(HttpPostInfo request) throws Exception {
        String ctype = "application/json;charset=UTF-8";
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        byte[] content = request.getBody();
        if (request.getBody() == null) {
            content = HttpUtil.getContentByHeader(request.getHeadParams(), DEFAULT_CHARSET);
        }
        try {
            boolean needCompression = HttpUtil.isNeedCompression(content);
            conn = HttpUtil.getConnection(HttpUtil.createConnectionInfo(request.getUrl(), METHOD_POST, ctype, request.getProxy()));
            if (needCompression) {
                conn.setRequestProperty("Content-Encoding", DEFAULT_COMPRESS_TYPE);
            }
            if (request.getUseJosAuth()) {
                conn.setRequestProperty("X-UseJosAuth", "true");
            }
            conn.setConnectTimeout(request.getConnectTimeout());
            conn.setReadTimeout(request.getReadTimeout());
            out = HttpUtil.getHttpOutputStream(needCompression, out, conn, content);
            rsp = HttpUtil.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String doUploadFile(String url, Map<String, String> headers, File file, int connectTimeout, int readTimeout) throws Exception {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = HttpUtil.getConnection(HttpUtil.createConnectionInfo(url, METHOD_POST, "", null));
            HttpUtil.supplyHttpHeaders(conn, headers);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out = HttpFileUtil.writeFile(file, out);
            rsp = HttpUtil.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String doUploadFile(HttpPostInfo postInfo, File file) throws Exception {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = HttpUtil.getConnection(HttpUtil.createConnectionInfo(postInfo.getUrl(), METHOD_POST, "", postInfo.getProxy() != null ? postInfo.getProxy() : null));
            HttpUtil.supplyHttpHeaders(conn, postInfo.getHeadParams());
            conn.setConnectTimeout(postInfo.getConnectTimeout());
            conn.setReadTimeout(postInfo.getReadTimeout());
            out = conn.getOutputStream();
            out = HttpFileUtil.writeFile(file, out);
            rsp = HttpUtil.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void doDownloadFile(String url, Map<String, String> headers, File file, int connectTimeout, int readTimeout) throws Exception {
        HttpURLConnection conn = null;
        Object rsp = null;
        try {
            conn = HttpUtil.getConnection(HttpUtil.createConnectionInfo(url, "GET", "", null));
            conn.setRequestProperty("Accept-Encoding", "*");
            HttpUtil.supplyHttpHeaders(conn, headers);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            HttpFileUtil.downloadFile(file, conn.getInputStream());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDownloadFile(HttpPostInfo postInfo, File file) throws Exception {
        HttpURLConnection conn = null;
        Object rsp = null;
        try {
            conn = HttpUtil.getConnection(HttpUtil.createConnectionInfo(postInfo.getUrl(), "GET", "", postInfo.getProxy() != null ? postInfo.getProxy() : null));
            conn.setRequestProperty("Accept-Encoding", "*");
            HttpUtil.supplyHttpHeaders(conn, postInfo.getHeadParams());
            conn.setConnectTimeout(postInfo.getConnectTimeout());
            conn.setReadTimeout(postInfo.getReadTimeout());
            HttpFileUtil.downloadFile(file, conn.getInputStream());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String doUploadFiles(String url, Map<String, String> headers, List<File> uploadFileList, int connectTimeout, int readTimeout) throws Exception {
        String boundary = Long.valueOf(System.currentTimeMillis()).toString();
        HttpURLConnection conn = null;
        FilterOutputStream dsOut = null;
        try {
            String rsp;
            conn = HttpUtil.getConnection(HttpUtil.createConnectionInfo(url, METHOD_POST, "", null));
            conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            HttpUtil.supplyHttpHeaders(conn, headers);
            dsOut = new DataOutputStream(conn.getOutputStream());
            HttpFileUtil.writeFiles((DataOutputStream)dsOut, uploadFileList, boundary);
            String string = rsp = HttpUtil.getResponseAsString(conn);
            return string;
        }
        finally {
            if (dsOut != null) {
                dsOut.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doUploadFiles(HttpPostInfo postInfo, List<File> uploadFileList) throws Exception {
        String boundary = Long.valueOf(System.currentTimeMillis()).toString();
        HttpURLConnection conn = null;
        FilterOutputStream dsOut = null;
        try {
            String rsp;
            conn = HttpUtil.getConnection(HttpUtil.createConnectionInfo(postInfo.getUrl(), METHOD_POST, "", postInfo.getProxy() != null ? postInfo.getProxy() : null));
            conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            HttpUtil.supplyHttpHeaders(conn, postInfo.getHeadParams());
            dsOut = new DataOutputStream(conn.getOutputStream());
            HttpFileUtil.writeFiles((DataOutputStream)dsOut, uploadFileList, boundary);
            String string = rsp = HttpUtil.getResponseAsString(conn);
            return string;
        }
        finally {
            if (dsOut != null) {
                dsOut.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static boolean isNeedCompression(byte[] content) {
        int length = 0;
        if (content != null) {
            length = content.length;
        }
        return length >= 102400;
    }

    @Deprecated
    public static String doPost(String url, Map<String, String> params, boolean useJosAuth, int connectTimeout, int readTimeout) throws Exception {
        HttpPostInfo postInfo = new HttpPostInfo.Builder().setConnectTimeout(connectTimeout).setReadTimeout(readTimeout).setUrl(url).setHeadParams(params).setUseJosAuth(useJosAuth).setCharset(DEFAULT_CHARSET).instance();
        return HttpUtil.doPostNoHeadersParam(postInfo);
    }

    @Deprecated
    public static String doPost(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws Exception {
        HttpPostInfo postInfo = new HttpPostInfo.Builder().setConnectTimeout(connectTimeout).setReadTimeout(readTimeout).setUrl(url).setHeadParams(params).setCharset(DEFAULT_CHARSET).instance();
        return HttpUtil.doPostNoHeadersParam(postInfo);
    }

    private static OutputStream getHttpOutputStream(boolean needCompression, OutputStream out, HttpURLConnection conn, byte[] content) throws IOException {
        if (needCompression) {
            out = new GZIPOutputStream(conn.getOutputStream());
            if (content != null && content.length > 0) {
                out.write(content);
            }
            if (needCompression) {
                ((GZIPOutputStream)out).finish();
            }
        } else {
            out = conn.getOutputStream();
            if (content != null && content.length > 0) {
                out.write(content);
            }
        }
        return out;
    }

    private static void supplyHttpHeaders(HttpURLConnection conn, Map<String, String> headerParams) {
        if (headerParams != null) {
            Set<Map.Entry<String, String>> entries = headerParams.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String name = entry.getKey();
                String value = entry.getValue();
                conn.setRequestProperty(name, value);
            }
        }
    }

    private static HttpURLConnection getConnection(ConnectionInfo info) throws IOException {
        HttpURLConnection conn = null;
        URL url = info.getUrl();
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx = null;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new DefaultTrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = null;
            connHttps = info.getProxy() != null ? (HttpsURLConnection)url.openConnection(info.getProxy()) : (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/html,application/json");
        conn.setRequestProperty("User-Agent", "lop-sdk-java/2.0");
        conn.setRequestProperty("Content-Type", info.getCtype());
        conn.setRequestProperty("Accept-Encoding", DEFAULT_COMPRESS_TYPE);
        conn.setRequestMethod(info.getMethod());
        return conn;
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = HttpUtil.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        String contentEncoding = conn.getContentEncoding();
        if (es == null) {
            return HttpUtil.getStreamAsString(conn.getInputStream(), charset, contentEncoding);
        }
        String msg = HttpUtil.getStreamAsString(es, charset, contentEncoding);
        if (StringUtil.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset, String contentEncoding) throws IOException {
        try {
            InputStreamReader isr = null;
            isr = DEFAULT_COMPRESS_TYPE.equalsIgnoreCase(contentEncoding) ? new InputStreamReader((InputStream)new GZIPInputStream(stream), charset) : new InputStreamReader(stream, charset);
            BufferedReader reader = new BufferedReader(isr);
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtil.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtil.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    private static ConnectionInfo createConnectionInfo(String url, String method, String ctype, Proxy proxy) throws MalformedURLException {
        return new ConnectionInfo.Builder().setUrl(new URL(url)).setMethod(method).setCtype(ctype).setProxy(proxy != null ? proxy : null).instance();
    }

    private static byte[] getContentByHeader(Map<String, String> params, String defaultCharset) throws Exception {
        String query = HttpUtil.buildQueryJson(params, defaultCharset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(defaultCharset);
        }
        return content;
    }

    public static void main(String[] args) throws Exception {
    }
}

