/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.plugin.factory;

import com.lop.open.api.sdk.DefaultDomainApiClient;
import com.lop.open.api.sdk.LopException;
import com.lop.open.api.sdk.internal.bean.TokenResult;
import com.lop.open.api.sdk.internal.parser.JsonParser;
import com.lop.open.api.sdk.internal.util.CodecUtil;
import com.lop.open.api.sdk.internal.util.HttpUtil;
import com.lop.open.api.sdk.internal.util.StringUtil;
import com.lop.open.api.sdk.plugin.LopPlugin;
import com.lop.open.api.sdk.plugin.LopPluginFactory;
import com.lop.open.api.sdk.plugin.entity.OAuth2Plugin;
import com.lop.open.api.sdk.request.info.HttpPostInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class OAuth2PluginFactory
implements LopPluginFactory {
    private static final int connectTimeout = 0;
    private static final int readTimeout = 0;
    private static final String TOKEN_INVALID_CODE = "19";
    private static final String TOKEN_EXPIRED_CODE = "29";
    private static final ConcurrentHashMap<String, OAuth2Plugin> accessTokenMap = new ConcurrentHashMap();

    public static LopPlugin produceLopPlugin(String appKey, String appSecret) {
        OAuth2Plugin oAuth2Plugin = new OAuth2Plugin();
        oAuth2Plugin.setAppKey(appKey);
        oAuth2Plugin.setAppSecret(appSecret);
        oAuth2Plugin.setVersion("v1");
        return oAuth2Plugin;
    }

    @Deprecated
    public static LopPlugin produceLopPlugin(String serverUrl, String appKey, String appSecret, String refreshToken, String oauthLopDn) throws LopException {
        serverUrl = serverUrl.trim();
        appKey = appKey.trim();
        appSecret = appSecret.trim();
        refreshToken = refreshToken.trim();
        oauthLopDn = oauthLopDn.trim();
        if (accessTokenMap.get(refreshToken) != null) {
            return accessTokenMap.get(refreshToken);
        }
        OAuth2Plugin oAuth2Plugin = new OAuth2Plugin();
        oAuth2Plugin.setAppKey(appKey);
        oAuth2Plugin.setAppSecret(appSecret);
        oAuth2Plugin.setRefreshToken(refreshToken);
        oAuth2Plugin.setOauthLopDn(oauthLopDn);
        oAuth2Plugin.setVersion("v1");
        if (StringUtil.isEmpty(serverUrl)) {
            throw new LopException("serverUrl can not be null");
        }
        StringBuilder baseUrl = new StringBuilder(100);
        try {
            URL url = new URL(serverUrl);
            String host = url.getHost();
            if (StringUtil.isEmpty(host)) {
                throw new LopException("invalid serverUrl:" + serverUrl);
            }
            baseUrl.append(url.getProtocol()).append("://").append(host);
            if (!StringUtil.equals("-1", url.getPort() + "")) {
                baseUrl.append(":").append(url.getPort());
            }
            OAuth2PluginFactory.refreshToken(baseUrl.toString(), oAuth2Plugin);
            accessTokenMap.put(refreshToken, oAuth2Plugin);
        }
        catch (MalformedURLException e) {
            throw new LopException(e);
        }
        return oAuth2Plugin;
    }

    public static LopPlugin produceLopPlugin(String serverUrl, String appKey, String appSecret, String refreshToken) throws LopException {
        return OAuth2PluginFactory.produceLopPlugin(serverUrl, appKey, appSecret, refreshToken, "oauth.jdwl.com");
    }

    public static LopPlugin produceLopPlugin(String appKey, String appSecret, String accessToken) {
        OAuth2Plugin oauthPlugin = new OAuth2Plugin();
        oauthPlugin.setAppKey(appKey.trim());
        oauthPlugin.setAccessToken(accessToken.trim());
        oauthPlugin.setAppSecret(appSecret.trim());
        oauthPlugin.setVersion("v1");
        return oauthPlugin;
    }

    public static LopPlugin produceLopPlugin(DefaultDomainApiClient client, String appKey, String appSecret, String refreshToken, String oauthLopDn) throws LopException {
        if (accessTokenMap.get(refreshToken) != null) {
            return accessTokenMap.get(refreshToken);
        }
        String serverUrl = client.getServerUrl();
        OAuth2Plugin oAuth2Plugin = new OAuth2Plugin();
        oAuth2Plugin.setAppKey(appKey);
        oAuth2Plugin.setAppSecret(appSecret);
        oAuth2Plugin.setRefreshToken(refreshToken);
        oAuth2Plugin.setOauthLopDn(oauthLopDn);
        oAuth2Plugin.setVersion("v1");
        if (StringUtil.isEmpty(serverUrl)) {
            throw new LopException("serverUrl can not be null");
        }
        try {
            URL url = new URL(serverUrl);
            String host = url.getHost();
            if (StringUtil.isEmpty(host)) {
                throw new LopException("invalid serverUrl:" + serverUrl);
            }
            OAuth2PluginFactory.refreshToken(client, oAuth2Plugin);
            accessTokenMap.put(refreshToken, oAuth2Plugin);
        }
        catch (MalformedURLException e) {
            throw new LopException(e);
        }
        return oAuth2Plugin;
    }

    public static LopPlugin produceLopPlugin(DefaultDomainApiClient client, OAuth2Plugin oAuth2Plugin) throws LopException {
        if (accessTokenMap.get(oAuth2Plugin.getRefreshToken()) != null) {
            return accessTokenMap.get(oAuth2Plugin.getRefreshToken());
        }
        String serverUrl = client.getServerUrl();
        if (StringUtil.isEmpty(serverUrl)) {
            throw new LopException("serverUrl can not be null");
        }
        try {
            URL url = new URL(serverUrl);
            String host = url.getHost();
            if (StringUtil.isEmpty(host)) {
                throw new LopException("invalid serverUrl:" + serverUrl);
            }
            OAuth2PluginFactory.refreshToken(client, oAuth2Plugin);
            accessTokenMap.put(oAuth2Plugin.getRefreshToken(), oAuth2Plugin);
        }
        catch (MalformedURLException e) {
            throw new LopException(e);
        }
        return oAuth2Plugin;
    }

    private static void refreshToken(String baseUrl, OAuth2Plugin plugin) throws LopException {
        String rsp;
        String sign;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timestamp = dateFormat.format(new Date());
        StringBuilder url = new StringBuilder(200);
        url.append(baseUrl).append("/oauth/refresh_token_ext?LOP-DN=").append(plugin.getOauthLopDn()).append("&app_key=").append(plugin.getAppKey()).append("&refresh_token=").append(plugin.getRefreshToken()).append("&timestamp=");
        try {
            url.append(URLEncoder.encode(timestamp, "UTF-8"));
            StringBuilder param = new StringBuilder(200);
            param.append(plugin.getAppSecret()).append("app_key").append(plugin.getAppKey()).append("refresh_token").append(plugin.getRefreshToken()).append("timestamp").append(timestamp).append(plugin.getAppSecret());
            sign = CodecUtil.md5(param.toString());
        }
        catch (Exception e) {
            throw new LopException("build url error", e);
        }
        url.append("&sign=").append(sign);
        try {
            HttpPostInfo postInfo = new HttpPostInfo.Builder().setConnectTimeout(0).setReadTimeout(0).setUrl(url.toString()).instance();
            rsp = HttpUtil.doPost(postInfo);
        }
        catch (Exception e) {
            throw new LopException(e);
        }
        JsonParser jsonParser = new JsonParser();
        TokenResult tokenResult = jsonParser.parseJson(rsp, TokenResult.class);
        if (tokenResult == null) {
            return;
        }
        if (tokenResult.isSuccess()) {
            if (tokenResult.getModel() == null) {
                return;
            }
        } else {
            throw new LopException(tokenResult.getErrMsg());
        }
        plugin.setAccessToken(tokenResult.getModel().getAccessToken());
    }

    private static void refreshToken(DefaultDomainApiClient client, OAuth2Plugin plugin) throws LopException {
        String rsp;
        String sign;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timestamp = dateFormat.format(new Date());
        StringBuilder url = new StringBuilder(200);
        url.append(client.getServerUrl()).append("/oauth/refresh_token_ext?LOP-DN=").append(plugin.getOauthLopDn()).append("&app_key=").append(plugin.getAppKey()).append("&refresh_token=").append(plugin.getRefreshToken()).append("&timestamp=");
        try {
            url.append(URLEncoder.encode(timestamp, "UTF-8"));
            StringBuilder param = new StringBuilder(200);
            param.append(plugin.getAppSecret()).append("app_key").append(plugin.getAppKey()).append("refresh_token").append(plugin.getRefreshToken()).append("timestamp").append(timestamp).append(plugin.getAppSecret());
            sign = CodecUtil.md5(param.toString());
        }
        catch (Exception e) {
            throw new LopException("build url error", e);
        }
        url.append("&sign=").append(sign);
        try {
            HttpPostInfo postInfo = new HttpPostInfo.Builder().setConnectTimeout(0).setReadTimeout(0).setUrl(url.toString()).setProxy(client.getProxy() != null ? client.getProxy() : null).instance();
            rsp = HttpUtil.doPost(postInfo);
        }
        catch (Exception e) {
            throw new LopException(e);
        }
        JsonParser jsonParser = new JsonParser();
        TokenResult tokenResult = jsonParser.parseJson(rsp, TokenResult.class);
        if (tokenResult == null) {
            return;
        }
        if (tokenResult.isSuccess()) {
            if (tokenResult.getModel() == null) {
                return;
            }
        } else {
            throw new LopException(tokenResult.getErrMsg());
        }
        plugin.setAccessToken(tokenResult.getModel().getAccessToken());
    }

    public static void clearAccessToken(String refreshToken) {
        accessTokenMap.remove(refreshToken);
    }

    public static boolean isAccessTokenExpired(String errorCode) {
        return TOKEN_INVALID_CODE.equals(errorCode) || TOKEN_EXPIRED_CODE.equals(errorCode);
    }
}

