/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.plugin.template;

import com.lop.open.api.sdk.internal.util.CodecUtil;
import com.lop.open.api.sdk.internal.util.StringUtil;
import com.lop.open.api.sdk.plugin.LopPlugin;
import com.lop.open.api.sdk.plugin.LopPluginTemplate;
import com.lop.open.api.sdk.plugin.entity.OAuth2Plugin;
import com.lop.open.api.sdk.request.DomainAbstractRequest;
import com.lop.open.api.sdk.request.DomainHttpParam;
import java.util.Map;
import java.util.TreeMap;

public class FileUploadTemplate
extends LopPluginTemplate {
    @Override
    public void buildHeaderParams(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
    }

    @Override
    public void buildUrlArgs(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        OAuth2Plugin oAuth2Plugin = (OAuth2Plugin)lopPlugin;
        TreeMap<String, String> sysParams = new TreeMap<String, String>();
        sysParams.put("method", domainRequest.getApiMethod());
        sysParams.put("access_token", oAuth2Plugin.getAccessToken());
        sysParams.put("app_key", oAuth2Plugin.getAppKey());
        sysParams.put("timestamp", domainRequest.getTimestamp());
        sysParams.put("v", domainRequest.getVersion());
        String signResult = this.sign(sysParams, oAuth2Plugin.getAppSecret());
        httpParam.addUrlArg("LOP-DN", domainRequest.getDomain());
        httpParam.addUrlArg("sign", signResult);
        httpParam.addUrlArg(sysParams);
    }

    @Override
    public void buildUrlPath(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        httpParam.setUrlPath(domainRequest.getApiMethod());
    }

    private String sign(Map<String, String> pmap, String appSecret) throws Exception {
        StringBuilder sb = new StringBuilder(appSecret);
        for (Map.Entry<String, String> entry : pmap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StringUtil.areNotEmpty(name, value)) continue;
            sb.append(name).append(value);
        }
        sb.append(appSecret);
        String result = CodecUtil.md5(sb.toString());
        return result;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(CodecUtil.md5("ef249108af934347acdaa28e18b9517daccess_tokend4d942b343674f7199a6a601bf7e9497app_key41cbb4b92a8a44bdac8aff91eb6b6e46method/lop/mulfile/uploadtimestamp2020-11-06 22:03:00v2.0ef249108af934347acdaa28e18b9517d"));
    }
}

