/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.plugin.template;

import com.lop.open.api.sdk.internal.util.HmacUtil;
import com.lop.open.api.sdk.internal.util.SM3Util;
import com.lop.open.api.sdk.internal.util.StringUtil;
import com.lop.open.api.sdk.plugin.LopPlugin;
import com.lop.open.api.sdk.plugin.LopPluginTemplate;
import com.lop.open.api.sdk.plugin.entity.HmacCustomizeSign;
import com.lop.open.api.sdk.plugin.entity.HmacPartnerPlugin;
import com.lop.open.api.sdk.plugin.enumerate.EncryptAlgorithm;
import com.lop.open.api.sdk.plugin.enumerate.HmacSourceType;
import com.lop.open.api.sdk.request.DomainAbstractRequest;
import com.lop.open.api.sdk.request.DomainHttpParam;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import sun.misc.BASE64Encoder;

public class HmacPartnerTemplate
extends LopPluginTemplate {
    @Override
    public void buildHeaderParams(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("LOP-DN", domainRequest.getDomain());
        httpParam.addHeaders(headerParams);
    }

    @Override
    public void buildUrlArgs(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        HmacPartnerPlugin hmacPlugin = (HmacPartnerPlugin)lopPlugin;
        httpParam.addUrlArg("timestamp", this.getTimeStamp(lopPlugin));
        httpParam.addUrlArg("app_key", hmacPlugin.getAppKey());
        httpParam.addUrlArg("algorithm", hmacPlugin.getAlgorithm().getName());
        httpParam.addUrlArg("sign", this.getSign(lopPlugin));
        httpParam.addUrlArg("v", domainRequest.getVersion());
    }

    @Override
    public void buildUrlPath(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        httpParam.setUrlPath(domainRequest.getApiMethod());
    }

    private String getTimeStamp(LopPlugin lopPlugin) throws UnsupportedEncodingException {
        HmacPartnerPlugin hmacPlugin = (HmacPartnerPlugin)lopPlugin;
        for (HmacCustomizeSign customizeSign : hmacPlugin.getCustomizeSignList()) {
            if (!StringUtil.equalsIgnoreCase("timestamp", customizeSign.getKey()) || customizeSign.getSourceType() != HmacSourceType.UrlArgs) continue;
            return customizeSign.getValue().toString();
        }
        return "";
    }

    private String getSign(LopPlugin lopPlugin) throws UnsupportedEncodingException {
        Object md5Sign;
        String sign = "";
        HmacPartnerPlugin hmacPlugin = (HmacPartnerPlugin)lopPlugin;
        List<HmacCustomizeSign> signList = hmacPlugin.getCustomizeSignList();
        StringBuilder signTxt = new StringBuilder();
        if (hmacPlugin.getAlgorithm() == EncryptAlgorithm.HMacSHA1 || hmacPlugin.getAlgorithm() == EncryptAlgorithm.HMacMD5 || hmacPlugin.getAlgorithm() == EncryptAlgorithm.HMacSHA256 || hmacPlugin.getAlgorithm() == EncryptAlgorithm.HMacSHA512) {
            Object secret = "";
            for (HmacCustomizeSign customizeSign : signList) {
                if (StringUtil.equalsIgnoreCase("isv_app_secret", customizeSign.getKey()) && customizeSign.getSourceType() == HmacSourceType.SystemVar) {
                    secret = customizeSign.getValue().toString();
                }
                signTxt.append(customizeSign.getValue());
            }
            try {
                byte[] digest = HmacUtil.encrypt(signTxt.toString(), (String)secret, hmacPlugin.getAlgorithm());
                sign = new BASE64Encoder().encode(digest).replaceAll("[\r\n]", "");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (hmacPlugin.getAlgorithm() == EncryptAlgorithm.md5_salt) {
            for (HmacCustomizeSign customizeSign : signList) {
                signTxt.append(customizeSign.getValue());
            }
            md5Sign = HmacUtil.MD5(signTxt.toString());
            sign = ((String)md5Sign).toLowerCase();
        } else if (hmacPlugin.getAlgorithm() == EncryptAlgorithm.sm3_salt) {
            for (HmacCustomizeSign customizeSign : signList) {
                signTxt.append(customizeSign.getValue());
            }
            md5Sign = SM3Util.hashHex(signTxt.toString());
            sign = ((String)md5Sign).toLowerCase();
        }
        HmacPartnerPlugin plugin = (HmacPartnerPlugin)lopPlugin;
        if (plugin.getHook() != null) {
            plugin.getHook().afterSigned(signTxt.toString(), sign);
        }
        return sign;
    }
}

