/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.plugin.template;

import com.lop.open.api.sdk.internal.util.HmacUtil;
import com.lop.open.api.sdk.internal.util.StringUtil;
import com.lop.open.api.sdk.plugin.LopPlugin;
import com.lop.open.api.sdk.plugin.LopPluginTemplate;
import com.lop.open.api.sdk.plugin.entity.HmacPlugin;
import com.lop.open.api.sdk.request.DomainAbstractRequest;
import com.lop.open.api.sdk.request.DomainHttpParam;
import java.util.HashMap;
import java.util.Map;

public class HmacTemplate
extends LopPluginTemplate {
    @Override
    public void buildHeaderParams(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> antiTamperMap = new HashMap<String, String>();
        HmacPlugin hmacPlugin = (HmacPlugin)lopPlugin;
        if (hmacPlugin.isAntiTamper()) {
            antiTamperMap.put("md5-content", HmacUtil.MD5(httpParam.getBodyContent()));
        }
        if (StringUtil.equalsIgnoreCase(hmacPlugin.getAlgorithm(), HmacUtil.Algorithm.hmac_sha1.getName())) {
            headerParams = HmacUtil.makeHmacHeaders(hmacPlugin.getUsername(), hmacPlugin.getPwd(), HmacUtil.Algorithm.hmac_sha1, antiTamperMap);
        }
        if (StringUtil.equalsIgnoreCase(hmacPlugin.getAlgorithm(), HmacUtil.Algorithm.md5_salt.getName())) {
            headerParams = HmacUtil.makeHmacHeaders(hmacPlugin.getUsername(), hmacPlugin.getPwd(), HmacUtil.Algorithm.md5_salt, antiTamperMap);
        }
        headerParams.put("LOP-DN", domainRequest.getDomain());
        httpParam.addHeaders(headerParams);
    }

    @Override
    public void buildUrlArgs(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
    }

    @Override
    public void buildUrlPath(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        httpParam.setUrlPath(domainRequest.getApiMethod());
    }

    public static void main(String[] args) {
        Map<String, String> headerParams = HmacUtil.makeHmacHeaders("wanghl", "123456", HmacUtil.Algorithm.hmac_sha1, new HashMap<String, String>());
        headerParams.forEach((k, v) -> System.out.println(k + ":" + v));
    }
}

