/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.plugin.template;

import com.lop.open.api.sdk.internal.fastjson.JSON;
import com.lop.open.api.sdk.plugin.LopPlugin;
import com.lop.open.api.sdk.plugin.LopPluginTemplate;
import com.lop.open.api.sdk.plugin.encry.RSAUtil;
import com.lop.open.api.sdk.plugin.entity.RsaCipherPlugin;
import com.lop.open.api.sdk.plugin.enumerate.CipherSource;
import com.lop.open.api.sdk.request.DomainAbstractRequest;
import com.lop.open.api.sdk.request.DomainHttpParam;
import org.apache.commons.codec.binary.Base64;

public class RsaCipherTemplate
extends LopPluginTemplate {
    @Override
    public void buildHeaderParams(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        RsaCipherPlugin plugin = (RsaCipherPlugin)lopPlugin;
        if (plugin.getCipherSourceType().intValue() == CipherSource.Header.getValue()) {
            String keyIv = plugin.getKeyRandom() + plugin.getIvRandom();
            byte[] cipherText = RSAUtil.encryptByPublicKey(keyIv.getBytes("UTF-8"), Base64.decodeBase64((String)plugin.getPublicKey()));
            httpParam.addHeaders("ciphertext", Base64.encodeBase64String((byte[])cipherText));
            httpParam.addHeaders("pkId", plugin.getPkId().toString());
        }
        httpParam.addHeaders("LOP-DN", domainRequest.getDomain());
    }

    @Override
    public void buildUrlPath(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        httpParam.setUrlPath(domainRequest.getApiMethod());
    }

    @Override
    public void buildUrlArgs(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        RsaCipherPlugin plugin = (RsaCipherPlugin)lopPlugin;
        if (plugin.getCipherSourceType().intValue() == CipherSource.UrlArgs.getValue()) {
            String keyIv = plugin.getKeyRandom() + plugin.getIvRandom();
            byte[] cipherText = RSAUtil.encryptByPublicKey(keyIv.getBytes("UTF-8"), Base64.decodeBase64((String)plugin.getPublicKey()));
            httpParam.addUrlArg("ciphertext", Base64.encodeBase64String((byte[])cipherText));
            httpParam.addUrlArg("pkId", plugin.getPkId().toString());
        }
    }

    @Override
    public void buildContent(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        RsaCipherPlugin plugin = (RsaCipherPlugin)lopPlugin;
        String bodyJsonText = JSON.toJSONString(domainRequest.getBodyObject());
        String bodyText = Base64.encodeBase64String((byte[])RSAUtil.encryptByKeyIv(bodyJsonText.getBytes("UTF-8"), plugin.getKeyRandom().getBytes("UTF-8"), plugin.getIvRandom().getBytes("UTF-8")));
        httpParam.addBodyJsonArgs(bodyText);
    }
}

