/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.request;

import com.lop.open.api.sdk.DefaultDomainApiClient;
import com.lop.open.api.sdk.plugin.LopPlugin;
import com.lop.open.api.sdk.plugin.LopPluginTemplate;
import com.lop.open.api.sdk.plugin.entity.HmacPlugin;
import com.lop.open.api.sdk.plugin.entity.OAuth2Plugin;
import com.lop.open.api.sdk.plugin.template.HmacTemplate;
import com.lop.open.api.sdk.plugin.template.OAuth2Template;
import com.lop.open.api.sdk.request.DomainAbstractRequest;
import com.lop.open.api.sdk.request.DomainHttpParam;
import com.lop.open.api.sdk.response.DomainResponse;
import java.util.List;

public class DomainApiGeneralRequest
extends DomainAbstractRequest<DomainResponse> {
    private DomainHttpParam domainHttpParam;
    private String apiMethod;
    private String domain;
    private List bodyObject;

    @Override
    public Class<DomainResponse> getResponseClass() {
        return DomainResponse.class;
    }

    @Override
    public DomainHttpParam buildDomainHttpParam(DefaultDomainApiClient client) throws Exception {
        if (this.domainHttpParam == null) {
            DomainHttpParam httpParam = new DomainHttpParam();
            List<LopPlugin> lopPluginList = this.getLopPluginList();
            if (null != lopPluginList && lopPluginList.size() > 0) {
                for (LopPlugin plugin : lopPluginList) {
                    LopPluginTemplate lopPluginTemplate = null;
                    if (plugin instanceof HmacPlugin) {
                        lopPluginTemplate = new HmacTemplate();
                        lopPluginTemplate.buildHttpParams(httpParam, this, plugin);
                    }
                    if (!(plugin instanceof OAuth2Plugin)) continue;
                    lopPluginTemplate = new OAuth2Template();
                    lopPluginTemplate.buildHttpParams(httpParam, this, plugin);
                }
            } else {
                httpParam.setUrlPath(this.getApiMethod());
                httpParam.addHeaders("LOP-DN", this.getDomain());
                httpParam.addBodyArgs(this.getBodyObject());
            }
            this.domainHttpParam = httpParam;
        }
        return this.domainHttpParam;
    }

    @Override
    public DomainHttpParam getDomainHttpParam() {
        return this.domainHttpParam;
    }

    public void setDomainHttpParam(DomainHttpParam domainHttpParam) {
        this.domainHttpParam = domainHttpParam;
    }

    @Override
    public String getApiMethod() {
        return this.apiMethod;
    }

    public void setApiMethod(String apiMethod) {
        this.apiMethod = apiMethod;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public List getBodyObject() {
        return this.bodyObject;
    }

    public void setBodyObject(List bodyObject) {
        this.bodyObject = bodyObject;
    }
}

