/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.request.info;

import java.net.Proxy;
import java.util.Map;

public class HttpPostInfo {
    private String url;
    private Map<String, String> headParams;
    private byte[] body;
    private boolean useJosAuth;
    private int connectTimeout;
    private int readTimeout;
    private String charset;
    private Proxy proxy;

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeadParams() {
        return this.headParams;
    }

    public boolean getUseJosAuth() {
        return this.useJosAuth;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getCharset() {
        return this.charset;
    }

    public HttpPostInfo() {
    }

    private HttpPostInfo(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.headParams = builder.headParams;
        this.body = builder.body;
        this.proxy = builder.proxy;
        this.url = builder.url;
        this.useJosAuth = builder.useJosAuth;
        this.charset = builder.charset;
    }

    public static class Builder {
        private String url;
        private Map<String, String> headParams;
        private byte[] body;
        private boolean useJosAuth;
        private int connectTimeout;
        private int readTimeout;
        private Proxy proxy;
        private String charset;

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setHeadParams(Map<String, String> headParams) {
            this.headParams = headParams;
            return this;
        }

        public Builder setBody(byte[] body) {
            this.body = body;
            return this;
        }

        public Builder setUseJosAuth(boolean useJosAuth) {
            this.useJosAuth = useJosAuth;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public Builder setProxy(Proxy proxy) {
            if (proxy != null) {
                this.proxy = proxy;
            }
            return this;
        }

        public HttpPostInfo instance() {
            return new HttpPostInfo(this);
        }
    }
}

