/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.util;

import com.lop.open.api.sdk.commons.EmDomainApiType;
import com.lop.open.api.sdk.commons.HttpContentType;
import com.lop.open.api.sdk.internal.fastjson.JSON;
import java.util.List;

public class DomainApiUtil {
    private static final String separator = ",";

    public static String buildHttpBodyObjectsJson(List bodyObjects, HttpContentType httpContentType) {
        if (HttpContentType.APPLICATION_JSON == httpContentType) {
            return DomainApiUtil.buildHttpBodyObjectsApplicationJson(bodyObjects);
        }
        return null;
    }

    private static String buildHttpBodyObjectsApplicationJson(List bodyObjects) {
        if (null == bodyObjects || bodyObjects.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bodyObjects.size() - 1; ++i) {
            Object bodyObject = bodyObjects.get(i);
            String bodyObjectJson = JSON.toJSONString(bodyObject);
            sb.append(bodyObjectJson);
            sb.append(separator);
        }
        Object lastBodyObject = bodyObjects.get(bodyObjects.size() - 1);
        String lastBodyObjectJson = JSON.toJSONString(lastBodyObject);
        sb.append(lastBodyObjectJson);
        return sb.toString();
    }

    public static boolean isHttpDomainApi(Integer domainApiTypeCode) {
        if (null == domainApiTypeCode) {
            return false;
        }
        EmDomainApiType domainApiType = EmDomainApiType.of(domainApiTypeCode);
        return EmDomainApiType.HTTP_SERVICE == domainApiType;
    }
}

