/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.util;

import com.lop.open.api.sdk.internal.util.HttpUtil;
import com.lop.open.api.sdk.internal.util.JsonUtil;
import com.lop.open.api.sdk.internal.util.SM3Util;
import com.lop.open.api.sdk.internal.util.StringUtil;
import com.lop.open.api.sdk.request.info.HttpPostInfo;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Encoder;

public class HmacPartnerRequestUtil {
    private String getSign(String appKey, String isvAppSecret, String apiMetood, String timestamp, String requestBody, String algorithm) throws Exception {
        String sign = "";
        ArrayList<String> signList = new ArrayList<String>(Arrays.asList(isvAppSecret, "app_key", appKey, "method", apiMetood, "param_json", requestBody, "timestamp", timestamp, "v", "2.0", isvAppSecret));
        StringBuffer buffer = new StringBuffer();
        for (String str : signList) {
            buffer.append(str);
        }
        String signStr = buffer.toString();
        if (algorithm.equals(AlgorithmEnum.HMACSHA1.getValue()) || algorithm.equals(AlgorithmEnum.HMACMD5.getValue()) || algorithm.equals(AlgorithmEnum.HMACSHA256.getValue()) || algorithm.equals(AlgorithmEnum.HMACSHA512.getValue())) {
            byte[] digest = this.encrypt(signStr, isvAppSecret, algorithm);
            sign = new BASE64Encoder().encode(digest).replaceAll("\r|\n", "");
        } else if (algorithm == AlgorithmEnum.MD5_SALT.getValue()) {
            sign = this.md5(signStr);
            sign = sign.toLowerCase();
        } else if (algorithm == AlgorithmEnum.SM3_SALT.getValue()) {
            String md5Sign = SM3Util.hashHex(signStr);
            sign = md5Sign.toLowerCase();
        }
        return URLEncoder.encode(sign, "UTF-8");
    }

    private byte[] encrypt(String encryptText, String secret, String algorithm) throws Exception {
        System.out.println(encryptText);
        System.out.println(secret);
        byte[] data = secret.getBytes("UTF-8");
        SecretKeySpec secretKey = new SecretKeySpec(data, algorithm);
        Mac mac = Mac.getInstance(algorithm);
        mac.init(secretKey);
        byte[] text = encryptText.getBytes("UTF-8");
        byte[] digest = mac.doFinal(text);
        return digest;
    }

    private String md5(String source) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] bytes = md.digest(source.getBytes("utf-8"));
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public String execute(String serverUrl, String appKey, String isvAppSecret, String apiMethod, String requestBody, String algorithm, String domainName) throws Exception {
        String requestUrl = this.getRequestUrl(serverUrl, appKey, isvAppSecret, apiMethod, requestBody, algorithm);
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("LOP-DN", domainName);
        HttpPostInfo postInfo = new HttpPostInfo.Builder().setConnectTimeout(0).setReadTimeout(0).setUrl(requestUrl).setHeadParams(headerParam).setBody(requestBody.getBytes()).instance();
        String rsp = HttpUtil.doPost(postInfo);
        if (rsp.indexOf("error_response") < 0) {
            rsp = "{\"response\":{\"content\":" + rsp + ", \"code\":0}}";
        }
        return rsp;
    }

    public String getRequestUrl(String serverUrl, String appKey, String isvAppSecret, String apiMethod, String requestBody, String algorithm) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timestamp = dateFormat.format(new Date());
        StringBuilder url = new StringBuilder(serverUrl);
        if (!StringUtil.isEmpty(apiMethod)) {
            url.append(apiMethod);
        }
        url.append("?timestamp=" + URLEncoder.encode(timestamp, "UTF-8") + "&app_key=" + appKey + "&algorithm=" + algorithm + "&v=2.0&sign=" + this.getSign(appKey, isvAppSecret, apiMethod, timestamp, requestBody, algorithm));
        return url.toString();
    }

    public static void main(String[] args) {
        try {
            HmacPartnerRequestUtil util = new HmacPartnerRequestUtil();
            ArrayList<Integer> arr = new ArrayList<Integer>();
            for (int i = 0; i < 1; ++i) {
                arr.add(3);
            }
            String requestBody = JsonUtil.toJson(arr);
            String string = util.execute("serverUrl", "appKey", "isvAppSecret", "apiMethod", requestBody, AlgorithmEnum.HMACSHA1.getValue(), "bbbbaaaaammgg");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum AlgorithmEnum {
        HMACSHA1("HMacSHA1", "HMacSHA1"),
        HMACMD5("HMacMD5", "HMacMD5"),
        HMACSHA256("HMacSHA256", "HMacSHA256"),
        HMACSHA512("HMacSHA512", "HMacSHA512"),
        MD5_SALT("md5-salt", "md5-salt"),
        SM3_SALT("sm3-salt", "sm3-salt");

        private String name;
        private String value;

        private AlgorithmEnum(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

