/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.metadata;

import com.opensymphony.xwork2.validator.metadata.ValidatorDescription;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExpressionValidatorDescription
implements ValidatorDescription {
    public String expression;
    public String key;
    public String message;
    public boolean shortCircuit;

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setShortCircuit(boolean shortCircuit) {
        this.shortCircuit = shortCircuit;
    }

    public String getFieldName() {
        throw new UnsupportedOperationException("ExpressionValidator annotations cannot be applied to fields...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asXml() {
        StringWriter sw = new StringWriter();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(sw);
            if (this.shortCircuit) {
                writer.println("\t<validator type=\"expression\">");
            } else {
                writer.println("\t<validator type=\"expression\" short-circuit=\"true\">");
            }
            writer.println("\t\t<param name=\"expression\">" + this.expression + "</param>");
            if (!"".equals(this.key)) {
                writer.println("\t\t<message key=\"" + this.key + "\">" + this.message + "</message>");
            } else {
                writer.println("\t\t<message>" + this.message + "</message>");
            }
            writer.println("\t</validator>");
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        return sw.toString();
    }

    public boolean isSimpleValidator() {
        return false;
    }
}

