package com.biz.eisp.base.common.constant;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class AccessStatus {

    @Description(value = "操作成功", key = 1000)
    public static int SERVER_SUCCESS = 1000;
    @Description(value = "服务器错误", key = 1001)
    public static int SERVER_GENERIC_ERROR = 1001;
    @Description(value = "缺少参数", key = 1002)
    public static int INVALID_REQUEST_PARAMETER = 1002;
    @Description(value = "登录过期,请重新登录", key = 1003)
    public static int INVALID_SECRET_TOKEN = 1003;
    @Description(value = "密码错误", key = 1004)
    public static int ACCOUNT_INVALID = 1004;
    @Description(value = "缺少参数", key = 1005)
    public static int MISS_PARAMETER = 1005;
    @Description(value = "搜索结果为空", key = 1006)
    public static int SEARCH_NULL = 1006;

    @Description(value = "没有匹配到UUID对应的表单", key = 2001)
    public static int FORM_NOT_FOUND_UUID = 2001;
    @Description(value = "没有匹配到对应的表单ID", key = 2002)
    public static int FORM_ID_NOT_FOUND = 2002;



    protected static Map<Integer, String> descriptionMap = new LinkedHashMap<>();

    static {
        Field[] fields = AccessStatus.class.getDeclaredFields();
        for (Field field : fields) {
            if (field.isAnnotationPresent(Description.class)) {
                Description description = field.getAnnotation(Description.class);
                descriptionMap.put(description.key(), description.value());
            }
        }
    }

    public static String getDescription(int errorCode) {
        return descriptionMap.get(errorCode);
    }
}
