package com.biz.eisp.base.common.hibernate.dialect;

import org.springframework.beans.factory.FactoryBean;

public class DialectFactoryBean implements FactoryBean<Dialect> {
	public static final String ORACLE = "oracle";
	public static final String MYSQL = "mysql";
	public static final String SQLSERVER = "sqlserver";
	public static final String DB2 = "db2";
	public static final String POSTGRES = "postgres";
	private Dialect dialect;
	private String dbType = "mysql";

	public void setDbType(String dbType) {
		this.dbType = dbType;
	}

	@Override
	public Dialect getObject() throws Exception {
		//TODO 获取数据库类型对应的方言
		if (this.dbType.equals("oracle")) {
			this.dialect = new OracleDialect();
		} else if (this.dbType.equals("mysql")) {
			this.dialect = new MySQLDialect();
		} else {
			throw new Exception("没有设置合适的数据库类型");
		}
		return this.dialect;
	}

	@Override
	public Class<?> getObjectType() {
		return Dialect.class;
	}

	@Override
	public boolean isSingleton() {
		return true;
	}
}