package com.biz.eisp.base.common.jsonmodel;

import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.constant.AccessStatus;
import com.biz.eisp.base.common.vo.BaseVo;

/**
 * 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
public class AjaxJson {

    private boolean success = true;// 是否成功
    private String msg = "操作成功";// 提示信息
    private BaseVo vo = null;//vo对象信息
    private Map<String, Object> attributes;//其他参数
    private Object obj;
    private int code;

    public AjaxJson() {
    	
    }
    
    /**
     * 操作成功
     * @param msg 操作成功提示信息
     */
    public AjaxJson(String msg) {
    	this.msg = msg;
    }
    
    /**
     * 操作成功
     * @param vo Vo对象信息
     */
    public AjaxJson(BaseVo vo) {
    	this.vo = vo;
    }
    
    /**
     * 操作成功
     * @param msg 操作成功提示信息
     * @param vo Vo对象信息
     */
    public AjaxJson(String msg, BaseVo vo) {
    	this.msg = msg;
    	this.vo = vo;
    }
    
    public Map<String, Object> getAttributes() { 
        return attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public BaseVo getVo() {
		return vo;
	}

	public void setVo(BaseVo vo) {
		this.vo = vo;
	}

	public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public AjaxJson(int code){
        this.code = code;
        this.setMsg(AccessStatus.getDescription(code));
    }

    public AjaxJson(int code, boolean flag){
        this.code = code;
        this.success = flag;
        this.setMsg(AccessStatus.getDescription(code));
    }

    public AjaxJson(int code,String message){
        this.code = code;
        this.msg = message;
    }

    public AjaxJson(int code,String message, boolean flag){
        this.code = code;
        this.msg = message;
        this.success = flag;
    }

    public AjaxJson(Object object){
        this.obj = object;
        this.code = AccessStatus.SERVER_SUCCESS;
        this.msg = AccessStatus.getDescription(AccessStatus.SERVER_SUCCESS);
    }

    public AjaxJson(Object object, boolean flag){
        this.obj = object;
        this.code = AccessStatus.SERVER_SUCCESS;
        this.success = flag;
        this.msg = AccessStatus.getDescription(AccessStatus.SERVER_SUCCESS);
    }

    public String getJsonStr() {
        JSONObject obj = new JSONObject();
        obj.put("success", this.isSuccess());
        obj.put("msg", this.getMsg());
        obj.put("vo", this.vo);
        obj.put("attributes", this.attributes);
        return obj.toJSONString();
    }

	public Object getObj() {
		return obj;
	}

	public void setObj(Object obj) {
		this.obj = obj;
	}

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}
