package com.biz.eisp.base.common.tag.bean;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.biz.eisp.base.common.util.StringUtil;

/**
 * 
 * @author liukai
 *
 */
public class DataGridUrl {
	private String id;
	/**
	 * 操作链接地址
	 */
	private String url;

	/**
	 * 按钮名称
	 */
	private String title;

	/**
	 * 按钮图标
	 */
	private String icon;

	/**
	 * 传入参数
	 */
	private String value;

	/**
	 * 弹出窗宽度
	 */
	private String width;

	/**
	 * 弹出窗高度
	 */
	private String height;

	/**
	 * 按钮类型
	 */
	private String type;

	/**
	 * 是否是操作选项以外的链接
	 */
	private String isbtn;

	/**
	 * 询问链接的提示语
	 */
	private String message;

	/**
	 * 判断链接是否显示的表达式
	 */
	private List<Expression> exps;

	/**
	 * 自定义函数名称
	 */
	private String funname;

	/**
	 * 是否是单选框
	 */
	private boolean isRadio;

	/**
	 * 选项单击事件
	 */
	private String onclick;

	private String functionname;

	private String param;

	private String params;

	public String getFunctionname() {
		return functionname;
	}

	public void setFunctionname(String functionname) {
		this.functionname = functionname;
	}

	public String getParam() {
		return param;
	}

	public void setParam(String param) {
		this.param = param;
	}

	public String getOnclick() {
		return onclick;
	}

	public void setOnclick(String onclick) {
		this.onclick = onclick;
	}

	public void setRadio(boolean isRadio) {
		this.isRadio = isRadio;
	}

	public String getFunname() {
		return funname;
	}

	public void setFunname(String funname) {
		this.setFunctionname(this.getFunction(funname));
		this.setParam(this.getFunParams(funname));
		this.funname = funname;
	}

	public String getMessage() {
		return message;
	}

	public List<Expression> getExps() {
		return exps;
	}

	public void setExps(List<Expression> exps) {
		this.exps = exps;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getIsbtn() {
		return isbtn;
	}

	public void setIsbtn(String isbtn) {
		this.isbtn = isbtn;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getType() {
		return type;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		if (StringUtil.isNotEmpty(url)) {
			url = formatUrl(url);
		}
		this.url = url;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public boolean isRadio() {
		return isRadio;
	}

	public String getWidth() {
		return width;
	}

	public void setWidth(String width) {
		this.width = width;
	}

	public String getHeight() {
		return height;
	}

	public String getIcon() {
		return icon;
	}

	public void setHeight(String height) {
		this.height = height;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	private String formatUrl() {
		String url = this.getUrl();
		MessageFormat formatter = new MessageFormat("");
		if (this.getValue() != null) {
			String[] testvalue = this.getValue().split(",");
			List value = new ArrayList<Object>();
			for (String string : testvalue) {
				value.add("\"+rec." + string + " +\"");
			}
			url = MessageFormat.format(url, value.toArray());
		}
		if (url != null && this.getValue() == null) {
			url = this.formatUrl(url);
		}
		return url;
	}

	/**
	 * 格式化URL
	 * 
	 * @return
	 */
	private String formatUrl(String url) {
		MessageFormat formatter = new MessageFormat("");
		String parurlvalue = "";
		if (url.indexOf("&") >= 0) {
			String beforeurl = url.substring(0, url.indexOf("&"));// 截取请求地址
			String parurl = url.substring(url.indexOf("&") + 1, url.length());// 截取参数
			String[] pras = parurl.split("&");
			List value = new ArrayList<Object>();
			int j = 0;
			for (int i = 0; i < pras.length; i++) {
				if (pras[i].indexOf("{") >= 0 || pras[i].indexOf("#") >= 0) {
					String field = pras[i].substring(pras[i].indexOf("{") + 1, pras[i].lastIndexOf("}"));
					parurlvalue += "&" + pras[i].replace("{" + field + "}", "{" + j + "}");
					value.add("\"+rec." + field + " +\"");
					j++;
				} else {
					parurlvalue += "&" + pras[i];
				}
			}
			url = MessageFormat.format(beforeurl + parurlvalue, value.toArray());
		}
		return url;
	}

	/**
	 * 获取自定义函数名
	 * 
	 * @param functionname
	 * @return
	 */
	private String getFunction(String functionname) {
		if (StringUtils.isNotBlank(functionname)) {
			int index = functionname.indexOf("(");
			if (index == -1) {
				return functionname;
			} else {
				return functionname.substring(0, functionname.indexOf("("));
			}
		} else {
			return functionname;
		}

	}

	/**
	 * 获取自定义函数的参数
	 * 
	 * @param functionname
	 * @return
	 */
	private String getFunParams(String functionname) {
		String param = "";
		if (StringUtils.isNotBlank(functionname)) {
			int index = functionname.indexOf("(");

			if (index != -1) {
				String testparam = functionname.substring(functionname.indexOf("(") + 1, functionname.length() - 1);
				if (StringUtil.isNotEmpty(testparam)) {
					String[] params = testparam.split(",");
					for (String string : params) {
						param += (string.indexOf("{") != -1)
								? ("'\"+" + string.substring(1, string.length() - 1) + "+\"',")
								: ("'\"+rec." + string + "+\"',");
					}
				}
			}
			param += "'\"+index+\"'";// 传出行索引号参数
		}
		return param;
	}

	public String getParams() {
		return params;
	}

	public void setParams(String params) {
		this.params = params;
	}

}
