package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.tag.params.AuthFilterParams;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.utils.FreemarkerParseUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.util.*;

/**
 * 
 * @Title:AuthFilterTag
 * @description:列表按钮权限过滤
 * @author Sean
 */
public class AuthFilterTag extends TagSupport{
	private static final long serialVersionUID = 1L;
	
	@Autowired
	private BaseService baseService;
	
	public int doStartTag() throws JspException {
		return super.doStartTag();
	}
	
	public int doEndTag() throws JspException {
		JspWriter out = null;
		try {
			out = this.pageContext.getOut();
			out.print(end().toString());
			out.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return EVAL_PAGE;
		
	}
	/**
	 * 获取隐藏按钮的JS代码
	 */
	@SuppressWarnings("unchecked")
	protected String end() {
		List<AuthFilterParams> list=new ArrayList<AuthFilterParams>();
		String content ="";
		Set<String> operationCodes = (Set<String>) super.pageContext.getRequest().getAttribute(Globals.OPERATIONCODES);
		if (null!=operationCodes) {
			for (String operationCode : operationCodes) {
				AuthFilterParams authFilter=new AuthFilterParams();
				if (StringUtil.isEmpty(operationCode))
					break;
//				TmOperationEntity operation = baseService.get(TmOperationEntity.class, operationCode);
//				if (operation.getOperationCode().startsWith(".") || operation.getOperationCode().startsWith("#")){
//					authFilter.setName(operation.getOperationCode().replaceAll(" ", ""));
//					if (operation.getOperationtype().intValue()==Globals.OPERATION_TYPE_HIDE){
//						authFilter.setType("0");
//					}else {
//						authFilter.setType("1");
//					}
//				}
				list.add(authFilter);
			}
			FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
			Map <String, Object> param = new HashMap<String, Object>();
			param.put("param", list);
			content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/authFilter.ftl", param);
		}
		return content;
	}
	
}
