package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.common.tag.params.AutoCompleteParams;
import com.biz.eisp.base.utils.FreemarkerParseUtils;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;


/**
 * 自动补全
 * @author Sean
 */
public class AutoCompleteTag extends TagSupport {
	private static final long serialVersionUID = 1L;
	private String name;//控件名称
	private String dataSource = "commonController.do?getAutoList";//数据源
	private Integer minLength=2;//触发提示文字长度
	private String labelField;//提示显示的字段
	private String searchField;//查询关键字字段
	private String valueField;//传递后台的字段
	private String entityName;//实体名称
	private String label;//传入显示值
	private String datatype = "*";//数据验证类型
	private String nullmsg = "";//数据为空时验证
	private String errormsg = "输入格式不对";//数据格式不对时验证
	private String parse; //解析获取到的数据
	private String formatItem; //格式化
	private String result; //获取结果
	private Integer maxRows = 10;//显示的最多的条数
	
	public int doStartTag() throws JspTagException {
		return EVAL_PAGE;
	}
	public int doEndTag() throws JspTagException {
		JspWriter out = null;
		try {
			out = this.pageContext.getOut();
			out.print(end());
			System.out.println(end().toString());
			out.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return EVAL_PAGE;
	}
	public String end() {
		
		AutoCompleteParams params=new AutoCompleteParams();
		params.setDataSource(dataSource);
		params.setDatatype(datatype);
		params.setEntityName(entityName);
		params.setErrormsg(errormsg);
		params.setFormatItem(formatItem);
		params.setLabel(label);
		params.setLabelField(labelField);
		params.setMaxRows(maxRows);
		params.setMinLength(minLength);
		params.setName(name);
		params.setNullmsg(nullmsg);
		params.setParse(parse);
		params.setResult(result);
		params.setSearchField(searchField);
		params.setValueField(valueField);
		FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
		Map <String, Object> param = new HashMap<String, Object>();
		param.put("param", params);
		String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/autoComplete.ftl", param);
		return content;
	}
	public void setName(String name) {
		this.name = name;
	}
	public void setParse(String parse) {
		this.parse = parse;
	}
	public void setFormatItem(String formatItem) {
		this.formatItem = formatItem;
	}
	public void setResult(String result) {
		this.result = result;
	}
	public void setDataSource(String dataSource) {
		this.dataSource = dataSource;
	}
	public void setMinLength(Integer minLength) {
		this.minLength = minLength;
	}
	public void setDatatype(String datatype) {
		this.datatype = datatype;
	}
	public void setNullmsg(String nullmsg) {
		this.nullmsg = nullmsg;
	}
	public void setErrormsg(String errormsg) {
		this.errormsg = errormsg;
	}
	public void setLabel(String label) {
		this.label = label;
	}
	public void setLabelField(String labelField) {
		this.labelField = labelField;
	}
	public void setValueField(String valueField) {
		this.valueField = valueField;
	}
	public void setEntityName(String entityName) {
		this.entityName = entityName;
	}
	public void setSearchField(String searchField) {
		this.searchField = searchField;
	}
	public void setMaxRows(Integer maxRows){
		if(maxRows==null){
			maxRows = 10;
		}
		this.maxRows = maxRows;
	}
}
