package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.common.tag.params.BaseParams;
import com.biz.eisp.base.utils.FreemarkerParseUtils;
import org.springframework.util.StringUtils;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * 页面父标签，引入js,css外部资源包
 * @author Sean
 */
public class BaseTag extends TagSupport {
	private static final long serialVersionUID = 1L;
	protected String type = "default";// 加载类型

	public void setType(String type) {
		this.type = type;
	}

	@Override
	public int doStartTag() throws JspException {
		return EVAL_PAGE;
	}

	@Override
	public int doEndTag() throws JspException {
		try {
			JspWriter out = this.pageContext.getOut();
			String content = this.end();
			out.print(content);
			out.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return EVAL_PAGE;
	}

	public String end() {
		BaseParams baseParams = new BaseParams();
		if(!StringUtils.isEmpty(type)) {
			baseParams.setTypes(StringUtils.commaDelimitedListToStringArray(type));
		}
		
		FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
		
		Map <String, Object> param = new HashMap<String, Object>();
		param.put("param", baseParams);
		String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/base.ftl", param);
		return content;
	}
}