package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.FreemarkerParseUtils;
import com.biz.eisp.base.utils.UUIDGenerator;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * 类描述：选择器标签
 * @author xuduan
 * @version v1.0
 */
public class ChooseTag extends TagSupport {
    /**
	 * 描述.
	 */
	private static final long serialVersionUID = 1L;
	protected String hiddenName;
    protected String textname;// 显示文本框字段
    protected String icon;
    protected String title;
    protected String url;
    protected String top;
    protected String left;
    protected String width;
    protected String height;
    protected String name;
    protected String hiddenid;// 隐藏框取值ID
    protected Boolean isclear = false;
    protected String fun;// 自定义函数
    protected String inputTextname;
    protected String parameter;//弹出查询参数

    @Override
    public int doStartTag() throws JspTagException {
        return EVAL_PAGE;
    }

    @Override
    public int doEndTag() throws JspTagException {
        try {
            JspWriter out = this.pageContext.getOut();
            out.print(end().toString());
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return EVAL_PAGE;
    }


    public String end() {

        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();

        Map<String, Object> params = new HashMap<String, Object>();
        params.put("confirm","确定");
        params.put("cancel","取消");
        params.put("methodname",UUIDGenerator.generate().replaceAll("-", ""));
        params.put("textname",textname);
        params.put("inputTextname",inputTextname);
        params.put("icon",icon);
        params.put("title",title);
        params.put("url",url);
        params.put("top",top);
        params.put("left",left);
        params.put("width",width);
        params.put("height",height);
        params.put("name",name);
        params.put("isclear",isclear);
        params.put("hiddenName", hiddenName);
        params.put("hiddenid", hiddenid);
        params.put("fun", fun);
        params.put("parameter",parameter);

        StringBuffer sb = new StringBuffer("");
        callback(sb,params.get("methodname").toString());
        params.put("clickcallback",sb.toString());


        Map<String, Object> param = new HashMap<String, Object>();
        param.put("param", params);
        String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/chose.ftl", param);
        return content;
    }

    /**
     * 点击确定回填
     *
     * @param sb
     */
    private void callback(StringBuffer sb, String methodname) {
        sb.append("function clickcallback_" + methodname + "(){");
        sb.append("iframe = this.iframe.contentWindow;");
        String[] textnames = null;
        String[] inputTextnames = null;
        if (StringUtil.isNotEmpty(textname)) {
            textnames = textname.split(",");
            if (StringUtil.isNotEmpty(inputTextname)) {
                inputTextnames = inputTextname.split(",");
            } else {
                inputTextnames = textnames;
            }
            for (int i = 0; i < textnames.length; i++) {
                inputTextnames[i] = inputTextnames[i].replaceAll("\\[", "\\\\\\\\[").replaceAll("\\]", "\\\\\\\\]")
                        .replaceAll("\\.", "\\\\\\\\.");
                sb.append("var " + textnames[i] + "=iframe.get" + name + "Selections(\'" + textnames[i] + "\');	");
                sb.append("if($(\'#" + inputTextnames[i] + "\').length>=1){");
                sb.append("$(\'#" + inputTextnames[i] + "\').val(" + textnames[i] + ");");
                sb.append("$(\'#" + inputTextnames[i] + "\').blur();");
                sb.append("}");
                sb.append("if($(\"input[name='" + inputTextnames[i] + "']\").length>=1){");
                sb.append("$(\"input[name='" + inputTextnames[i] + "']\").val(" + textnames[i] + ");");
                sb.append("$(\"input[name='" + inputTextnames[i] + "']\").blur();");
                sb.append("}");
            }
        }
        if (StringUtil.isNotEmpty(hiddenName)) {
            sb.append("var id =iframe.get" + name + "Selections(\'" + hiddenid + "\');");
            sb.append("if (id!== undefined &&id!=\"\"){");
            sb.append("$(\'#" + hiddenName + "\').val(id);");
            sb.append("}");
        }
        if (StringUtil.isNotEmpty(fun)) {
            sb.append("" + fun + "();");// 执行自定义函数
        }
        sb.append("}");
    }

    public void setHiddenName(String hiddenName) {
        this.hiddenName = hiddenName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setTextname(String textname) {
        this.textname = textname;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTop(String top) {
        this.top = top;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setIsclear(Boolean isclear) {
        this.isclear = isclear;
    }

    public void setHiddenid(String hiddenid) {
        this.hiddenid = hiddenid;
    }

    public void setFun(String fun) {
        this.fun = fun;
    }

    public String getInputTextname() {
        return inputTextname;
    }

    public void setInputTextname(String inputTextname) {
        this.inputTextname = inputTextname;
    }


	public String getParameter() {
		return parameter;
	}

	public void setParameter(String parameter) {
		this.parameter = parameter;
	}
    
    
}
