package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.common.tag.params.CkfinderParams;
import com.biz.eisp.base.utils.FreemarkerParseUtils;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * ckfinder标签
 * @author Sean
 * @date 2016年9月29日
 * @version 1.0
 */
public class CkfinderTag extends TagSupport {

	private static final long serialVersionUID = 1L;
	protected String name;// 属性名称
	protected String value;// 默认值
	protected String width;// 显示图片宽(上传类型为Images时)
	protected String height;// 显示图片高(上传类型为Images时)
	protected String buttonClass;// 按钮样式
	protected String buttonValue;// 按钮名称
	protected String uploadType;// 上传类型(Images,Files,Flash)

	public String getButtonValue() {
		return buttonValue;
	}

	public void setButtonValue(String buttonValue) {
		this.buttonValue = buttonValue;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getWidth() {
		return width;
	}

	public void setWidth(String width) {
		this.width = width;
	}

	public String getHeight() {
		return height;
	}

	public void setHeight(String height) {
		this.height = height;
	}

	public String getButtonClass() {
		return buttonClass;
	}

	public void setButtonClass(String buttonClass) {
		this.buttonClass = buttonClass;
	}

	public String getUploadType() {
		return uploadType;
	}

	public void setUploadType(String uploadType) {
		this.uploadType = uploadType;
	}

	public int doStartTag() throws JspTagException {
		return EVAL_PAGE;
	}

	public int doEndTag() throws JspTagException {
		JspWriter out = null;
		try {
			out = this.pageContext.getOut();
			out.print(end());
			out.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			try {
				out.clear();
				out.close();
			} catch (Exception e2) {
			}
		}
		return EVAL_PAGE;
	}

	public String end() {
		CkfinderParams params=new CkfinderParams();
		params.setButtonClass(buttonClass);
		params.setButtonValue(buttonValue);
		params.setHeight(height);
		params.setName(name);
		params.setUploadType(uploadType);
		params.setValue(value);
		params.setWidth(width);
		FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
		Map <String, Object> param = new HashMap<String, Object>();
		param.put("param", params);
		String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/ckfinder.ftl", param);
		return content;
	}
}
