package com.biz.eisp.base.common.tag.tags;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * 列表操作项处理标签
 * @author liukai
 *
 */
public class DataGridConfOptTag extends TagSupport {
	private static final long serialVersionUID = 1L;
	
	protected String url;//列表操作URL
	protected String title;//列表操作标题
	private String message;//询问链接的提示语
	private String exp;//判断链接是否显示的表达式
	private String operationCode;//按钮的操作Code
	
	@Override
	public int doStartTag() throws JspTagException {
		return EVAL_PAGE;
	}
	
	@Override
	public int doEndTag() throws JspTagException {
		Tag t = findAncestorWithClass(this, DataGridTag.class);
		DataGridTag parent = (DataGridTag) t;
		parent.setConfUrl(url, title, message, exp, operationCode);
		return EVAL_PAGE;
	}
	
	public void setExp(String exp) {
		this.exp = exp;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public void setMessage(String message) {
		this.message = message;
	}
	public void setOperationCode(String operationCode) {
		this.operationCode = operationCode;
	}
	
}

