package com.biz.eisp.base.common.tag.tags;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * 列表默认操作项标签
 * @author liukai
 *
 */

@SuppressWarnings("serial")
public class DataGridDefOptTag extends TagSupport {
	
	//列表操作URL
	protected String url;
	
	//列表操作标题
	protected String title;
	
	// 判断链接是否显示的表达式
	private String exp;
	
	//按钮的操作Code
	private String operationCode;
	
	@Override
	public int doStartTag() throws JspTagException {
		return EVAL_PAGE;
	}
	
	@Override
	public int doEndTag() throws JspTagException {
		Tag t = findAncestorWithClass(this, DataGridTag.class);
		DataGridTag parent = (DataGridTag) t;
		parent.setDefUrl(url, title, exp,operationCode);
		return EVAL_PAGE;
	}
	
	public void setExp(String exp) {
		this.exp = exp;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public void setOperationCode(String operationCode) {
		this.operationCode = operationCode;
	}
	
}