package com.biz.eisp.base.common.tag.tags;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;


/**
 * 列表删除操作项标签
 * @author liukai
 *
 */
@SuppressWarnings("serial")
public class DataGridDelOptTag extends TagSupport {
	
	//操作URL
	protected String url;
	
	//列表操作标题
	protected String title;
	
	/**
	 * 询问链接的提示语
	 */
	private String message;
	
	/**
	 * 判断链接是否显示的表达式
	 */
	private String exp;
	
	/**
	 * 自定义函数名称
	 */
	private String funname;
	
	/**
	 * 按钮的操作Code
	 */
	private String operationCode;
	
	@Override
	public int doStartTag() throws JspTagException {
		return EVAL_PAGE;
	}
	@Override
	public int doEndTag() throws JspTagException {
		Tag t = findAncestorWithClass(this, DataGridTag.class);
		DataGridTag parent = (DataGridTag) t;
		parent.setDelUrl(url, title, message, exp, funname,operationCode);
		return EVAL_PAGE;
	}
	public void setFunname(String funname) {
		this.funname = funname;
	}
	public void setExp(String exp) {
		this.exp = exp;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public void setMessage(String message) {
		this.message = message;
	}
	public void setOperationCode(String operationCode) {
		this.operationCode = operationCode;
	}
}
