package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.tag.bean.ColumnValue;
import com.biz.eisp.base.common.tag.bean.DataGridUrl;
import com.biz.eisp.base.common.tag.bean.Expression;
import com.biz.eisp.base.common.tag.bean.OptTypeDirection;
import com.biz.eisp.base.common.tag.params.DataGridParams;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TagUtil;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.base.utils.FreemarkerParseUtils;
import com.biz.eisp.base.utils.ModelMapperUtils;
import com.biz.eisp.rpc.DynamicConfigRpcService;
import com.biz.eisp.vo.DataGridColumn;
import com.biz.eisp.vo.DictDataVo;
import com.biz.eisp.vo.TmOperationVo;
import com.biz.eisp.vo.TmTableConfigVo;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;


/**
 * datagrid标签
 * @author Sean
 * @date 2016年9月28日
 * @version 3.0
 */
@SuppressWarnings({"all"})
public class DataGridTag extends TagSupport {
	protected String fields = "";// 显示字段
	protected String searchFields = "";// 查询字段  
	protected String name;// 表格标示
	protected String title;// 表格标示
	protected String idField="id";// 主键字段
	protected boolean treegrid = false;// 是否是树形列表
	public Map<String, Object> map;// 封装查询条件
	private String actionUrl;// 分页提交路径
	public int allCount;//总行数
	public int curPageNo;//当前页
	public int pageSize = 10;//分页显示条数
	public boolean pagination = true;// 是否显示分页
	private String width;//宽度
	private String height;//高度
	private boolean checkbox = false;// 是否显示复选框
	private boolean showPageList = true;// 定义是否显示页面列表
	private boolean openFirstNode = false;//是不是展开第一个节点
	private boolean fit = true;// 是否允许表格自动缩放，以适应父容器
	private boolean fitColumns = true;// 当为true时，自动展开/合同列的大小，以适应的宽度，防止横向滚动.
	private boolean singleSelect = true;// 是否为单选
	private String sortName;//定义的列进行排序
	private String sortOrder = "asc";//定义列的排序顺序，只能是"递增"或"降序".
	private boolean showRefresh = true;// 定义是否显示刷新按钮
	private boolean showText = true;// 定义是否显示刷新按钮
	private String style = "easyui";// 列表样式easyui,datatables
	private String onLoadSuccess;// 数据加载完成调用方法
	private String onClick;// 单击事件调用方法
	private String onDblClick;// 双击事件调用方法
	private String queryMode = "single";//查询模式
	private String entityName;//对应的实体对象
	private String rowStyler;//rowStyler函数
	private String extendParams;//扩展参数,easyui有的,但是eisp没有的参数进行扩展
	private String extendTableName;//扩展字段表名  该字段不为空时 需要执行查询 获取表对应的扩展配置
	private boolean autoLoadData=true; // 列表是否自动加载数据
	private boolean queryBuilder = false;// 高级查询器
	protected List<DataGridUrl> urlList = new ArrayList<DataGridUrl>();// 列表操作显示
	protected List<DataGridUrl> toolBarList = new ArrayList<DataGridUrl>();// 工具条列表
	protected List<DataGridColumn> columnList = new ArrayList<DataGridColumn>();// 列表操作显示
	protected List<DataGridColumn> multiMeterColumnList = new ArrayList<DataGridColumn>();//多表头跨行跨列操作显示
	protected List<ColumnValue> columnValueList = new ArrayList<ColumnValue>();// 值替换集合
	protected List<ColumnValue> columnStyleList = new ArrayList<ColumnValue>();// 颜色替换集合
	protected List<TmTableConfigVo> tableConfigList=new ArrayList<TmTableConfigVo>();//扩展字段
	//json转换中的系统保留字
	protected static Map<String,String> syscode = new HashMap<String,String>();
	static{
		syscode.put("class", "clazz");
	}
	
	@Autowired  
	private static BaseService baseService;
	
	/**
	 * 设置询问操作URL
	 */
	public void setConfUrl(String url, String title, String message, String exp,String operationCode) {
		DataGridUrl dataGridUrl = new DataGridUrl();
		dataGridUrl.setTitle(title);
		dataGridUrl.setUrl(url);
		dataGridUrl.setType(OptTypeDirection.OPTTYPE_CONFIRM);
		dataGridUrl.setMessage(message);
		dataGridUrl.setExps(getExp(exp));
		installOperationCode(dataGridUrl, operationCode,urlList);
	}
	
	/**
	 * 设置删除操作URL
	 */
	public void setDelUrl(String url, String title, String message, String exp, String funname,String operationCode) {
		DataGridUrl dataGridUrl = new DataGridUrl();
		dataGridUrl.setTitle(title);
		dataGridUrl.setUrl(url);
		dataGridUrl.setType(OptTypeDirection.OPTTYPE_DEL);
		dataGridUrl.setMessage(message);
		dataGridUrl.setExps(getExp(exp));
		dataGridUrl.setFunname(funname);
		installOperationCode(dataGridUrl, operationCode,urlList);
	}
	
	/**
	 * 设置默认操作URL
	 */
	public void setDefUrl(String url, String title, String exp,String operationCode) {
		DataGridUrl dataGridUrl = new DataGridUrl();
		dataGridUrl.setTitle(title);
		dataGridUrl.setUrl(url);
		dataGridUrl.setType(OptTypeDirection.OPTTYPE_DEFF);
		dataGridUrl.setExps(getExp(exp));
		installOperationCode(dataGridUrl, operationCode,urlList);
	}
	
	/**
	 * 设置工具条
	 * @param height2 
	 * @param width2 
	 */
	public void setToolbar(String url, String title, String icon, String exp,String onclick,
			String funname,String operationCode,String width,String height, String id, String params) {
		DataGridUrl dataGridUrl = new DataGridUrl();
		if(StringUtils.isBlank(id)) {
			dataGridUrl.setId(UUID.randomUUID().toString());
		} else {
			dataGridUrl.setId(id);
		}
		dataGridUrl.setTitle(title);
		dataGridUrl.setUrl(url);
		dataGridUrl.setType(OptTypeDirection.OPTTYPE_TOOLBAR);
		dataGridUrl.setIcon(icon);
		dataGridUrl.setExps(getExp(exp));
		dataGridUrl.setOnclick(onclick);
		dataGridUrl.setFunname(funname);
		dataGridUrl.setParams(params == null ? "" : params);
		dataGridUrl.setWidth(width == null ? "" : width);
		dataGridUrl.setHeight(height == null ? "" : height);
		installOperationCode(dataGridUrl, operationCode,toolBarList);
	}

	/**
	 * 设置自定义函数操作URL
	 */
	public void setFunUrl(String title, String exp, String funname,String operationCode) {
		DataGridUrl dataGridUrl = new DataGridUrl();
		dataGridUrl.setTitle(title);
		dataGridUrl.setType(OptTypeDirection.OPTTYPE_FUN);
		dataGridUrl.setExps(getExp(exp));
		dataGridUrl.setFunname(funname);
		String parmars = TagUtil.getFunParams(dataGridUrl.getFunname());
		dataGridUrl.setParam(parmars);
		installOperationCode(dataGridUrl, operationCode,urlList);
		
	}

	/**
	 * 设置自定义函数操作URL
	 */
	public void setOpenUrl(String url, String title, String width,String height,String exp,String operationCode,String openModel) {
		DataGridUrl dataGridUrl = new DataGridUrl();
		dataGridUrl.setTitle(title);
		dataGridUrl.setUrl(url);
		dataGridUrl.setWidth(width);
		dataGridUrl.setHeight(height);
		dataGridUrl.setType(openModel);
		dataGridUrl.setExps(getExp(exp));
		installOperationCode(dataGridUrl, operationCode,urlList);
		
	}
	
	private List<Expression> getExp(String exp){
		List<Expression> list=new ArrayList<Expression>();
		if (StringUtils.isNotBlank(exp)) {
			String[] showbyFields = exp.split("&&").length==0?exp.split("||"):exp.split("&&");
			for (int i=0;i<showbyFields.length;i++) {
				String showbyField=showbyFields[i];
				Expression e=new Expression();
				int beginIndex = showbyField.indexOf("#");
				int endIndex = showbyField.lastIndexOf("#");
				String exptype = showbyField.substring(beginIndex + 1, endIndex);// 表达式类型
				String field = showbyField.substring(0, beginIndex);// 判断显示依据字段
				String[] values = showbyField.substring(endIndex + 1, showbyField.length()).split(",");// 传入字段值
				String value = "";
				for (int j = 0; j < values.length; j++) {
					value +=  "" + values[j] + "";
					if (j< values.length - 1) {
						value += ",";
					}
				}
				e.setValue(value);
				e.setCondition(exptype);
				e.setParam(field);
				list.add(e);
			}
		}
		return list;
	}
	


	/**
	 * <b>Summary: </b> setColumn(设置字段)
	 * @param title
	 * @param field
	 * @param width
	 */
	public void setColumn(DataGridColumn dataGridColumn) {
		if(StringUtil.isNotEmpty(dataGridColumn.getColspan())||
				StringUtil.isNotEmpty(dataGridColumn.getRowspan())){
			multiMeterColumnList.add(dataGridColumn);
		}else{
			columnList.add(dataGridColumn);
		}
		
		
		String field = dataGridColumn.getField();
		String replace = dataGridColumn.getReplace();
		String dictionary = dataGridColumn.getDictionary();
		String popup = null;
		//权限
		List operationCodes = (List) super.pageContext.getRequest().getAttribute(Globals.No_Operation_Codes);
		if (null!=operationCodes) {
		    List<TmOperationVo> tmOperationVos = ModelMapperUtils.toParseList(operationCodes,TmOperationVo.class);
			for (TmOperationVo operationEntity : tmOperationVos) {
				if (StringUtil.isEmpty(operationEntity.getOperationCode()))
					break;
				baseService = (BaseService) ApplicationContextUtils.getContext().getBean("baseService");
				if(operationEntity.getOperationCode().equals(dataGridColumn.getField())){
					columnList.remove(dataGridColumn);
				}
			}
		}
		
		if (field != "opt") {
			fields += field + ",";
			if ("group".equals(queryMode)) {
				searchFields += field + "," + field + "_begin," + field + "_end,";
			} else {
				searchFields += field + ",";
			}
		}
		
		if (StringUtils.isNotEmpty(replace)) {
			String[] test = replace.split(",");
			String lang_key = "";
			String text = "";
			String value = "";
			for (String string : test) {
				lang_key = string.substring(0, string.indexOf("_"));
				text += lang_key + ",";
				value += string.substring(string.indexOf("_") + 1) + ",";
			}
			setColumn(field, text, value);

		}
		if (!StringUtils.isBlank(dictionary)) {
			String[] enumInfo = null;
			boolean enumSuccess = false;
			if (dictionary.startsWith("enum")){
				enumInfo = dictionary.split(",");
				if (enumInfo.length==4){
					String enumClzName = enumInfo[1];
					String enumValueFiled = enumInfo[2];
					String enumDescFiled = enumInfo[3];
					try {
						Class<?> enumClazz = Class.forName(enumClzName);
						Method method = enumClazz.getMethod("values");
						char[] enumValueChars = enumValueFiled.toCharArray();
						if ('a'<=enumValueChars[0]&&enumValueChars[0]<='z'){
							enumValueChars[0] += 'A'-'a';
						}
						char[] enumDescChars = enumDescFiled.toCharArray();
						if ('a'<=enumDescChars[0]&&enumDescChars[0]<='z'){
							enumDescChars[0] += 'A'-'a';
						}
						Method getValueMethod = enumClazz.getMethod("get" + String.valueOf(enumValueChars));
						Method getDescMethod = enumClazz.getMethod("get" + String.valueOf(enumDescChars));
						Object[] enums = (Object[]) method.invoke(null);
						String text1 = "";
						String value1 = "";
						for (Object e : enums){
							Object value = getValueMethod.invoke(e);
							Object desc = getDescMethod.invoke(e);
							text1+=desc+",";
							value1+=value+",";
						}
						setColumn(field, text1, value1);
						enumSuccess = true;
					} catch (ClassNotFoundException e) {
						e.printStackTrace();
					} catch (NoSuchMethodException e) {
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						e.printStackTrace();
					} catch (InvocationTargetException e) {
						e.printStackTrace();
					}
				}else if (enumInfo.length==3){
					String enumClzName = enumInfo[1];
					String enumDescFiled = enumInfo[2];
					Class<?> enumClazz = null;
					try {
						enumClazz = Class.forName(enumClzName);
						Method method = enumClazz.getMethod("values");
						char[] enumDescChars = enumDescFiled.toCharArray();
						if ('a'<=enumDescChars[0]&&enumDescChars[0]<='z'){
							enumDescChars[0] += 'A'-'a';
						}
						Method getDescMethod = enumClazz.getMethod("get" + String.valueOf(enumDescChars));
						Object[] enums = (Object[]) method.invoke(null);
						String text1 = "";
						String value1 = "";
						for (Object e : enums){
							Object desc = getDescMethod.invoke(e);
							text1+=desc+",";
							value1+=e+",";
						}
						setColumn(field, text1, value1);
						enumSuccess = true;
					} catch (ClassNotFoundException e) {
						e.printStackTrace();
					} catch (NoSuchMethodException e) {
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						e.printStackTrace();
					} catch (InvocationTargetException e) {
						e.printStackTrace();
					}
				}
			}
			if (!enumSuccess){
				if(dictionary.contains(",")){
					String[] dic = dictionary.split(",");
					String text = "";
					String value = "";
					String sql = "select " + dic[1] + " as field," + dic[2]
							+ " as text from " + dic[0];
					List<Map<String, Object>> list = baseService.findForMapList(sql);
					for (Map<String, Object> map : list){
						text += map.get("text") + ",";
						value += map.get("field") + ",";
					}
					if(list.size()>0)
						setColumn(field, text, value);
				}else{
					String text = "";
					String value = "";
					baseService = (BaseService) ApplicationContextUtils.getContext().getBean("baseService");
					List<DictDataVo> dictDataList = baseService.
									findBySql(DictDataVo.class,
									"select dict_code dictCode,dict_value dictValue  from tm_dict_data where dict_type_code=?",
									dictionary);
					for (DictDataVo data  : dictDataList) {
						text += data.getDictValue() + ",";
						value += data.getDictCode() + ",";
					}
					setColumn(field, text, value);
				}
			}
		}
		if(StringUtils.isNotEmpty(style)){
			String[] temp = style.split(",");
			String text = "";
			String value = "";
			if(temp.length == 1&&temp[0].indexOf("_")==-1){
				text = temp[0];
			}else{
				for (String string : temp) {
					text += string.substring(0, string.indexOf("_")) + ",";
					value += string.substring(string.indexOf("_") + 1) + ",";
				}
			}
			setStyleColumn(field, text, value);
		}
	}
	
	/**
	 * 描述：组装菜单按钮操作权限
	 * dateGridUrl：url
	 * operationCode：操作码
	 * optList： 操作列表
	 * @version 1.0
	 */
	private void installOperationCode(DataGridUrl dataGridUrl,String operationCode,List optList){
		 if(!StringUtil.isEmpty(operationCode)){
             List operationCodes = (List) super.pageContext.getRequest().getAttribute(Globals.No_Operation_Codes);
             if (null!=operationCodes) {
                 List<TmOperationVo> tmOperationVos = ModelMapperUtils.toParseList(operationCodes,TmOperationVo.class);
				List<String> operationCodesStr = new ArrayList<String>();
				for (TmOperationVo operationEntity : tmOperationVos) {
					if (StringUtil.isEmpty(operationEntity.getOperationCode()))
						break;
					operationCodesStr.add(operationEntity.getOperationCode());
				}
				if (!operationCodesStr.contains(operationCode)){
					optList.add(dataGridUrl);
				}
			}
		}else {
			optList.add(dataGridUrl);
		}
	}
	
	/**
	 * 设置 颜色替换值
	 * @param field
	 * @param text
	 * @param value
	 */
	private void setStyleColumn(String field, String text, String value) {
		ColumnValue columnValue = new ColumnValue();
		columnValue.setName(field);
		columnValue.setText(text);
		columnValue.setValue(value);
		columnStyleList.add(columnValue);
	}

	/**
	 * 
	 * <b>Summary: </b> setColumn(设置字段替换值)
	 * 
	 * @param name
	 * @param text
	 * @param value
	 */
	public void setColumn(String name, String text, String value) {
		ColumnValue columnValue = new ColumnValue();
		columnValue.setName(name);
		columnValue.setText(text);
		columnValue.setValue(value);
		columnValueList.add(columnValue);
	}

	@Override
	public int doStartTag() throws JspTagException {
		// 清空资源
		urlList.clear();
		toolBarList.clear();
		columnValueList.clear();
		columnStyleList.clear();
		columnList.clear();
		multiMeterColumnList.clear();
		fields = "";
		searchFields = "";
		return EVAL_PAGE;
	}

	@Override
	public int doEndTag() throws JspException {
		try {
			JspWriter out = this.pageContext.getOut();
			out.print(end());
		} catch (IOException e) {
			e.printStackTrace();
		}
		return EVAL_PAGE;
	}

	public void setStyle(String style) {
		this.style = style;
	}
	/**
	 * 检测并封装扩展数据到column里去
	 */
	private void setExtendColumn(){
		DynamicConfigRpcService dynamicConfigRpcService = (DynamicConfigRpcService) ApplicationContextUtils.getContext().getBean("dynamicConfigRpcServiceImpl");
		List<DataGridColumn> dataGridColumnList=dynamicConfigRpcService.buildDataGridColumn(extendTableName,treegrid);
		if (CollectionUtil.listNotEmptyNotSizeZero(dataGridColumnList)) {
			for (int i = 0; i < dataGridColumnList.size(); i++) {
				DataGridColumn dataGridColumn =dataGridColumnList.get(i);
				dataGridColumn.setCheckbox(checkbox);
				setColumn(dataGridColumn);
			}
		}
		
	}
	/**
	 * Datagrid构造方法
	 * @return
	 */
	public String end() {
		if (StringUtils.isNotBlank(extendTableName)) {
			//检测并封装扩展数据到column里去
			setExtendColumn();
		}
		
		//参数封装
		DataGridParams dataGridParams = new DataGridParams();
		dataGridParams.setCheckbox(String.valueOf(this.checkbox));
		dataGridParams.setSingleSelect(String.valueOf(singleSelect));
		dataGridParams.setQueryMode(this.queryMode);
		dataGridParams.setWidth(this.width == null ? "auto" : width);
		dataGridParams.setHeight(this.height == null ? "auto" : height);
		dataGridParams.setTreegrid(String.valueOf(this.treegrid));
		dataGridParams.setName(this.name);
		dataGridParams.setActionUrl(this.actionUrl);
		dataGridParams.setTitle(this.title);
		dataGridParams.setRowStyler(this.rowStyler);
		dataGridParams.setFit(String.valueOf(this.fit));
		dataGridParams.setFitColumns(String.valueOf(this.fitColumns));
		dataGridParams.setToolBarList(this.toolBarList);
		dataGridParams.setColumnStyleList(this.columnStyleList);
		dataGridParams.setColumnValueList(this.columnValueList);
		dataGridParams.setMultiMeterColumnList(this.multiMeterColumnList);
		Collections.sort(columnList);
		dataGridParams.setColumnList(this.columnList);
		dataGridParams.setFields(this.fields);
		dataGridParams.setSearchFields(this.searchFields);
		dataGridParams.setIdField(this.idField);
		dataGridParams.setMap(this.map);
		dataGridParams.setAllCount(this.allCount);
		dataGridParams.setCurPageNo(this.curPageNo);
		dataGridParams.setPageSize(this.pageSize);
		dataGridParams.setPagination(String.valueOf(this.pagination));
		dataGridParams.setShowPageList(String.valueOf(this.showPageList));
		dataGridParams.setOpenFirstNode(String.valueOf(this.openFirstNode));
		dataGridParams.setSortName(this.sortName);
		dataGridParams.setSortOrder(this.sortOrder);
		dataGridParams.setShowRefresh(String.valueOf(this.showRefresh));
		dataGridParams.setShowText(String.valueOf(this.showText));
		dataGridParams.setStyle(this.style);
		dataGridParams.setOnLoadSuccess(this.onLoadSuccess);
		dataGridParams.setOnClick(this.onClick);
		dataGridParams.setOnDblClick(this.onDblClick);
		dataGridParams.setEntityName(this.entityName);
		dataGridParams.setExtendParams(this.extendParams);
		dataGridParams.setAutoLoadData(String.valueOf(this.autoLoadData));
		dataGridParams.setUrlList(this.urlList);
		
		//传入参数 解析freemarker模板
		FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
		Map <String, Object> param = new HashMap<String, Object>();
		param.put("param", dataGridParams);
		String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/datagrid.ftl", param);
		return content;
	}

	public DataGridColumnTag getDataGridColumnTag() {
		DataGridColumnTag dataGridColumnTag = new DataGridColumnTag();
		return dataGridColumnTag;
	}
	
	public boolean isFitColumns() {
		return fitColumns;
	}

	public void setFitColumns(boolean fitColumns) {
		this.fitColumns = fitColumns;
	}

	public String getSortName() {
		return sortName;
	}

	public void setSortName(String sortName) {
		this.sortName = sortName;
	}

	public String getSortOrder() {
		return sortOrder;
	}

	public void setSortOrder(String sortOrder) {
		this.sortOrder = sortOrder;
	}
	public String getQueryMode() {
		return queryMode;
	}

	public void setQueryMode(String queryMode) {
		this.queryMode = queryMode;
	}

	public boolean isAutoLoadData() {
		return autoLoadData;
	}

	public void setAutoLoadData(boolean autoLoadData) {
		this.autoLoadData = autoLoadData;
	}

	public void setOpenFirstNode(boolean openFirstNode) {
		this.openFirstNode = openFirstNode;
	}

	public void setEntityName(String entityName) {
		this.entityName = entityName;
	}

	public void setRowStyler(String rowStyler) {
		this.rowStyler = rowStyler;
	}

	public void setExtendParams(String extendParams) {
		this.extendParams = extendParams;
	}

	public boolean isQueryBuilder() {
		return queryBuilder;
	}

	public void setQueryBuilder(boolean queryBulder) {
		this.queryBuilder = queryBulder;
	}
	
	public void setOnLoadSuccess(String onLoadSuccess) {
		this.onLoadSuccess = onLoadSuccess;
	}

	public void setOnClick(String onClick) {
		this.onClick = onClick;
	}

	public void setOnDblClick(String onDblClick) {
		this.onDblClick = onDblClick;
	}

	public void setShowText(boolean showText) {
		this.showText = showText;
	}

	public void setPagination(boolean pagination) {
		this.pagination = pagination;
	}

	public void setCheckbox(boolean checkbox) {
		this.checkbox = checkbox;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public void setTreegrid(boolean treegrid) {
		this.treegrid = treegrid;
	}

	public void setWidth(String width) {
		this.width = width;
	}

	public void setHeight(String height) {
		this.height = height;
	}

	public void setIdField(String idField) {
		this.idField = idField;
	}

	public void setActionUrl(String actionUrl) {
		this.actionUrl = actionUrl;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setFit(boolean fit) {
		this.fit = fit;
	}

	public void setShowPageList(boolean showPageList) {
		this.showPageList = showPageList;
	}

	public void setShowRefresh(boolean showRefresh) {
		this.showRefresh = showRefresh;
	}

	/**
	 *  getter extendTableName
	 *  @return extendTableName
	 */
	public String getExtendTableName() {
		return extendTableName;
	}

	/**
	 *  setter extendTableName   
	 * 
	 */
	public void setExtendTableName(String extendTableName) {
		this.extendTableName = extendTableName;
	}

	/**
	 * getter singleSelect
	 * @return singleSelect
	 */
	public boolean isSingleSelect() {
		return singleSelect;
	}

	/**
	 * setter singleSelect   
	 */
	public void setSingleSelect(boolean singleSelect) {
		this.singleSelect = singleSelect;
	}
}