package com.biz.eisp.base.common.tag.tags;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * 列表工具条标签
 * @author liukai
 *
 */
public class DataGridToolBarTag extends TagSupport {
	private static final long serialVersionUID = 1L;
	
	/**
	 * 列表操作URL
	 */
	protected String url;
	
	/**
	 * 列表操作标题
	 */
	protected String title;

	/**
	 * 判断链接是否显示的表达式
	 */
	private String exp;

	/**
	 * 自定义函数名称
	 */
	private String funname;

	/**
	 * 图标
	 */
	private String icon;
	/**
	 * 单击事件
	 */
	private String onclick;
	/**
	 * 弹窗宽 度
	 */
	private String width;
	/**
	 * 弹窗高度
	 */
	private String height;

	/**
	 * 按钮的操作Code
	 */
	private String operationCode;
	
	private String params;

	@Override
	public int doStartTag() throws JspTagException {
		return EVAL_PAGE;
	}

	@Override
	public int doEndTag() throws JspTagException {
		Tag t = findAncestorWithClass(this, DataGridTag.class);
		DataGridTag parent = (DataGridTag) t;
		parent.setToolbar(url, title, icon, exp, onclick, funname, operationCode, width, height, id, params);
		return EVAL_PAGE;
	}

	public void setFunname(String funname) {
		this.funname = funname;
	}

	public void setExp(String exp) {
		this.exp = exp;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public void setOnclick(String onclick) {
		this.onclick = onclick;
	}

	public void setOperationCode(String operationCode) {
		this.operationCode = operationCode;
	}

	public void setWidth(String width) {
		this.width = width;
	}

	public void setHeight(String height) {
		this.height = height;
	}

	public void setParams(String params) {
		this.params = params;
	}
	
	
	
	
}
