package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.FreemarkerParseUtils;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * 动态报表input控件
 *
 * @author keith
 *
 */
public class InputSelectTag extends TagSupport {

    private static final long serialVersionUID = 1;
    private String code; // tm_cg_head code值
    private String method; // 选择之后处理逻辑
    private String id; // id
    private String name; // name
    private String style; // 样式


    @Override
    public int doStartTag() throws JspTagException {
        return EVAL_PAGE;
    }

    @Override
    public int doEndTag() throws JspTagException {
        try {
            JspWriter out = this.pageContext.getOut();
            out.print(end().toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return EVAL_PAGE;
    }

    public String end() {
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        Map<String, Object> param = new HashMap<String, Object>();
        Map<String, Object> textMap = new HashMap<String, Object>();
        textMap.put("code", code);
        textMap.put("method", method);
        textMap.put("id", id);
        textMap.put("name", name);
        if(StringUtil.isEmpty(style)){
            style = "";
        }
        textMap.put("style", style);

        param.put("param",textMap);
        return freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/inputSelect.ftl", param);
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStyle() {
        return style;
    }

    public void setStyle(String style) {
        this.style = style;
    }
}
