package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.utils.FreemarkerParseUtils;
import com.biz.eisp.base.utils.UUIDGenerator;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * 类简述:人区客品业务标签.
 * @author grover
 * @version v1.0
 */
public class SearcherTag extends TagSupport {
	private static final long serialVersionUID = 1L;
	protected String title;
	protected String hiddenId;
	protected String inputTextId;
    protected String inputTextName;// 显示文本框字段
    protected String hiddenFields;// 隐藏框字段
    protected String url;//请求url
    protected String dialogUrl;//判断是否弹出url
    protected String top;
    protected String left;
    protected String width;
    protected String height;
    protected String name;
    protected Boolean isClear = true;
    protected String fun;// 自定义函数
    protected String parameter;//弹出查询参数
    protected String type;//业务类别
    protected Boolean singleSelect = true;//列表是否单选
    protected String value;//默认值
    
	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doEndTag()
	 */
	@Override
	public int doEndTag() throws JspException {
		 try {
            JspWriter out = this.pageContext.getOut();
            out.print(end().toString());
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return EVAL_PAGE;
	}
	
	 public String end() {
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        Map<String, Object> params = new HashMap<String, Object>();
        //url处理
        if("1".equals(type)){//用户
        	url="tmUserController.do?goTmUserSearch";
        	dialogUrl="tmUserController.do?getTmUserBySearch";
        }else if("2".equals(type)){//职位
        	url="tmPositionController.do?goTmPositionSearch";
        	dialogUrl="tmPositionController.do?getTmPositionBySearchList";
        }else if("3".equals(type)){//客户
        	url="tmCustomerController.do?goTmCustSearch";
        	dialogUrl="tmCustomerController.do?getTmCustomerBySearchList";
        }else if("4".equals(type)){//终端
        	url="tmTerminalController.do?goTerminalSearch";
        	dialogUrl="tmTerminalController.do?getTerminalBySearchList";
        }else if("5".equals(type)){//产品
        	url="tmProductController.do?goProductSearch";
        	dialogUrl="tmProductController.do?getProductBySearchList";
        }else{
        	return "type参数异常";
        }
        params.put("url",url);
        params.put("dialogUrl",dialogUrl);
        params.put("confirm","确定");
        params.put("cancel","取消");
        params.put("methodname",UUIDGenerator.generate().replaceAll("-", ""));
        params.put("inputTextId",inputTextId);
        params.put("inputTextName",inputTextName);
        params.put("title",title);
        params.put("top",top);
        params.put("left",left);
        params.put("width",width);
        params.put("height",height);
        params.put("name",name);
        params.put("isClear",isClear);
        params.put("hiddenId", hiddenId);
        params.put("hiddenFields", hiddenFields);
        params.put("fun", fun);
        params.put("parameter",parameter);
        params.put("type", type);
        params.put("singleSelect", singleSelect);
        params.put("value", value);

        Map<String, Object> param = new HashMap<String, Object>();
        param.put("param", params);
        String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/searcher.ftl", param);
        return content;
    }
	
	/* (non-Javadoc)
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() throws JspException {
		 return EVAL_PAGE;
	}
	
	/**
	 * getter title
	 * @return title
	 */
	public String getTitle() {
		return title;
	}
	/**
	 * setter title   
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	/**
	 * getter hiddenId
	 * @return hiddenId
	 */
	public String getHiddenId() {
		return hiddenId;
	}
	/**
	 * setter hiddenId   
	 */
	public void setHiddenId(String hiddenId) {
		this.hiddenId = hiddenId;
	}
	/**
	 * getter inputTextId
	 * @return inputTextId
	 */
	public String getInputTextId() {
		return inputTextId;
	}
	/**
	 * setter inputTextId   
	 */
	public void setInputTextId(String inputTextId) {
		this.inputTextId = inputTextId;
	}
	/**
	 * getter inputTextName
	 * @return inputTextName
	 */
	public String getInputTextName() {
		return inputTextName;
	}
	/**
	 * setter inputTextName   
	 */
	public void setInputTextName(String inputTextName) {
		this.inputTextName = inputTextName;
	}
	/**
	 * getter hiddenFields
	 * @return hiddenFields
	 */
	public String getHiddenFields() {
		return hiddenFields;
	}
	/**
	 * setter hiddenFields   
	 */
	public void setHiddenFields(String hiddenFields) {
		this.hiddenFields = hiddenFields;
	}
	/**
	 * getter url
	 * @return url
	 */
	public String getUrl() {
		return url;
	}
	/**
	 * setter url   
	 */
	public void setUrl(String url) {
		this.url = url;
	}
	/**
	 * getter top
	 * @return top
	 */
	public String getTop() {
		return top;
	}
	/**
	 * setter top   
	 */
	public void setTop(String top) {
		this.top = top;
	}
	/**
	 * getter left
	 * @return left
	 */
	public String getLeft() {
		return left;
	}
	/**
	 * setter left   
	 */
	public void setLeft(String left) {
		this.left = left;
	}
	/**
	 * getter width
	 * @return width
	 */
	public String getWidth() {
		return width;
	}
	/**
	 * setter width   
	 */
	public void setWidth(String width) {
		this.width = width;
	}
	/**
	 * getter height
	 * @return height
	 */
	public String getHeight() {
		return height;
	}
	/**
	 * setter height   
	 */
	public void setHeight(String height) {
		this.height = height;
	}
	/**
	 * getter name
	 * @return name
	 */
	public String getName() {
		return name;
	}
	/**
	 * setter name   
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * getter isClear
	 * @return isClear
	 */
	public Boolean getIsClear() {
		return isClear;
	}
	/**
	 * setter isClear   
	 */
	public void setIsClear(Boolean isClear) {
		this.isClear = isClear;
	}
	/**
	 * getter fun
	 * @return fun
	 */
	public String getFun() {
		return fun;
	}
	/**
	 * setter fun   
	 */
	public void setFun(String fun) {
		this.fun = fun;
	}
	/**
	 * getter parameter
	 * @return parameter
	 */
	public String getParameter() {
		return parameter;
	}
	/**
	 * setter parameter   
	 */
	public void setParameter(String parameter) {
		this.parameter = parameter;
	}
	/**
	 * getter type
	 * @return type
	 */
	public String getType() {
		return type;
	}
	/**
	 * setter type   
	 */
	public void setType(String type) {
		this.type = type;
	}
	/**
	 * getter singleSelect
	 * @return singleSelect
	 */
	public Boolean getSingleSelect() {
		return singleSelect;
	}
	/**
	 * setter singleSelect   
	 */
	public void setSingleSelect(Boolean singleSelect) {
		this.singleSelect = singleSelect;
	}

	/**
	 * getter dialogUrl
	 * @return dialogUrl
	 */
	public String getDialogUrl() {
		return dialogUrl;
	}

	/**
	 * setter dialogUrl   
	 */
	public void setDialogUrl(String dialogUrl) {
		this.dialogUrl = dialogUrl;
	}

	/**
	 * getter value
	 * @return value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * setter value   
	 */
	public void setValue(String value) {
		this.value = value;
	}
}
