package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.common.tag.bean.Tab;
import com.biz.eisp.base.common.tag.params.TabsParams;
import com.biz.eisp.base.utils.FreemarkerParseUtils;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 类描述：选项卡标签
 * @author wuzhujun
 * @version v1.0
 */
public class TabsTag extends TagSupport {
   
	private static final long serialVersionUID = 1L;
	
	private String id;// 容器ID
    private String width;// 宽度
    private String height;// 高度
    private boolean plain;// 简洁模式
    private boolean fit = true;// 铺满浏览器
    private boolean border;// 边框
    private String scrollIncrement;// 滚动增量
    private String scrollDuration;// 滚动时间
    private boolean tools;// 工具栏
    private boolean tabs = true;// 是否创建父容器
    private boolean iframe = true;// 是否是iframe方式
    private String tabPosition = "top";// 选项卡位置
    private List<Tab> tabList = new ArrayList<Tab>();

    public void setIframe(boolean iframe) {
        this.iframe = iframe;
    }

    public void setTabs(boolean tabs) {
        this.tabs = tabs;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setHeigth(String height) {
        this.height = height;
    }

    public void setPlain(boolean plain) {
        this.plain = plain;
    }

    public void setFit(boolean fit) {
        this.fit = fit;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public void setScrollIncrement(String scrollIncrement) {
        this.scrollIncrement = scrollIncrement;
    }

    public void setScrollDuration(String scrollDuration) {
        this.scrollDuration = scrollDuration;
    }

    public void setTools(boolean tools) {
        this.tools = tools;
    }

    public String getTabPosition() {
        return tabPosition;
    }

    public void setTabPosition(String tabPosition) {
        this.tabPosition = tabPosition;
    }

    public void setTabList(List<Tab> tabList) {
        this.tabList = tabList;
    }

   

    @Override
    public int doStartTag() throws JspTagException {
        tabList.clear();
        return EVAL_PAGE;
    }

    @Override
    public int doEndTag() throws JspTagException {
        try {
            JspWriter out = this.pageContext.getOut();
            out.print(end1());
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return EVAL_PAGE;
    }
    public String end1(){
    	TabsParams tabsParams = new  TabsParams();
    	tabsParams.setId(id);
    	tabsParams.setHeight(this.height == null ?"100%":height);
    	tabsParams.setWidth(this.width == null ? "100%" :width);
    	tabsParams.setPlain(String.valueOf(this.plain));
    	tabsParams.setBorder(String.valueOf(this.border));
    	tabsParams.setFit(String.valueOf(this.fit));
    	tabsParams.setTabs(String.valueOf(this.tabs));
    	tabsParams.setIframe(String.valueOf(this.iframe));
    	tabsParams.setTools(String.valueOf(this.tools));
    	tabsParams.setScrollDuration(this.scrollDuration);
    	tabsParams.setScrollIncrement(this.scrollIncrement);
    	tabsParams.setTabPosition(this.tabPosition);
    	tabsParams.setTabList(this.tabList);
    	
    	FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
		Map <String, Object> param = new HashMap<String, Object>();
		param.put("param", tabsParams);
		String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/tabs.ftl", param);
		return content;
    }
   
    public void setTab(String id, String title, String iframe, String href, String iconCls, boolean cache,
                    String content, String width, String heigth, String closable) {
        Tab tab = new Tab();
        tab.setId(id);
        tab.setTitle(title);
        tab.setHref(href);
        tab.setCache(cache);
        if(cache){
            tab.setRefresh("true");
        }else{
            tab.setRefresh("false");
        }
        tab.setIframe(iframe);
        tab.setContent(content);
        tab.setHeigth(heigth);
        tab.setIcon(iconCls);
        tab.setWidth(width);
        tab.setClosable(closable);
        tabList.add(tab);
    }

}
