package com.biz.eisp.base.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;

public class ComboxTreeUtil implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public static String comboxTag="orgTree";
	public static  ConcurrentHashMap<String, List<ComboTree>> currMap=new ConcurrentHashMap<String, List<ComboTree>>();
	/**检测并扩展数据*/
	public static void addMap(){
		
	}
	
    public static void makenewMap(List<ComboTree> oldTrees,List<ComboTree> addTrees,String orgId,String parentId,int type){
    	switch (type) {//type 1新增  2修改 3删除 4更换 上级组织
		case 1:
		case 2:
			add(oldTrees, addTrees, parentId);
			break;
		case 3:
			delete(oldTrees, orgId);
			break;
		case 4:
	
	break;

		default:
			break;
		}
	}
    /**
     * 修改树
     * @param oldTrees
     * @param addTrees
     * @param parentId
     */
	private static boolean updateParent(List<ComboTree> oldTrees, List<ComboTree> addTrees,String parentId) {
		boolean b=false;
		List<ComboTree> childrenold = new ArrayList<ComboTree>();
		for (ComboTree old : oldTrees) {
			if (old.getId().equals(parentId)) {
				childrenold = old.getChildren();
				if (addTrees != null) {
					if (childrenold != null) {
						childrenold.addAll(addTrees);
					} else {
						childrenold = new ArrayList<ComboTree>();
						childrenold.addAll(addTrees);
					}
					old.setChildren(childrenold);
				}
				b=true;
				break;
			}else{
				if (old.getChildren()!=null&&old.getChildren().size()>0) {
					b= add(old.getChildren(), addTrees, parentId);
					if (b) {
						break;
					}
				}
			}
		}
		return b;
	}
    /**
     * 修改树
     * @param oldTrees
     * @param addTrees
     * @param parentId
     */
	private static boolean add(List<ComboTree> oldTrees, List<ComboTree> addTrees,String parentId) {
		boolean b=false;
		List<ComboTree> childrenold = new ArrayList<ComboTree>();
		for (ComboTree old : oldTrees) {
			if (old.getId().equals(parentId)) {
				childrenold = old.getChildren();
				if (addTrees != null) {
					if (childrenold != null) {
						childrenold.addAll(addTrees);
					} else {
						childrenold = new ArrayList<ComboTree>();
						childrenold.addAll(addTrees);
					}
					old.setChildren(childrenold);
				}
				b=true;
				break;
			}else{
				if (old.getChildren()!=null&&old.getChildren().size()>0) {
					b= add(old.getChildren(), addTrees, parentId);
					if (b) {
						break;
					}
				}
			}
		}
		return b;
	}
	/**
	 * 删除树
	 * @param oldTrees
	 * @param orgId
	 */
	private static boolean delete(List<ComboTree> oldTrees, String orgId) {
		boolean b=false;
		List<ComboTree> childrenold = new ArrayList<ComboTree>();
		for (ComboTree old : oldTrees) {
			if (old.getId().equals(orgId)) {
				childrenold = old.getChildren();
				if (childrenold!=null) {
					b=true;
					oldTrees.remove(old);
					break;
				}
			}else{
				if(old.getChildren()!=null&&old.getChildren().size()>0){
					b=delete(old.getChildren(), orgId);
					if (b) {
						break;
					}
				}
			}
		}
		return b;
	}
	
	/**
	 * 获取当前对象树
	 * @param comboTrees
	 * @param comboTreeModel
	 * @param obj
	 * @return
	 */
	public static List<ComboTree> getComboxByObj(List<ComboTree> comboTrees,ComboTreeModel comboTreeModel,Object obj){
		List<ComboTree> trees=new ArrayList<ComboTree>();
		ReflectHelper reflectHelper = new ReflectHelper(obj);
		String id = OConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getIdField()));
		ComboTree tmp=null;
		for (ComboTree ct : comboTrees) {
			if (ct!=null&&ct.getId().equals(id)) {
				tmp=ct;
				trees.add(tmp);
			}else{
				List<ComboTree> children=ct.getChildren();
				for (ComboTree chir : children) {
					tmp=sementTrees(chir,id);
					if (tmp!=null) {
						trees.add(tmp);
						break;
					}
				}
			}
		}
		return trees;
	}
	/**
	 * 拆分树
	 */
	private static ComboTree sementTrees(ComboTree ct,String id){
		boolean b=false;
		ComboTree tmp=null;
		if (ct!=null&&ct.getId().equals(id)) {
				b=true;
				tmp= ct;
		}else{
			List<ComboTree> children=ct.getChildren();
			if(children!=null&&children.size()>0){
			   for (ComboTree comboTree : children) {
				 tmp=sementTrees(comboTree, id);
				 if (tmp!=null) {//如果找到就直接退出循环
					break;
				 }
			   }
			}else{
				tmp= null;
			}
		}
		  return tmp;
	}
}
