package com.biz.eisp.base.common.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import com.biz.eisp.base.common.exception.BusinessException;

/**
 * @ClassName: ContextHolderUtils
 * @Description: TODO(上下文工具类)
 * @author Biz
 * @date 2012-12-15 下午11:27:39
 *
 */
public class ContextHolderUtils {
	
	//用户自己设计的Session，这里导入功能，自己启动的线程在使用这个属性，自己设置的Session
	private static HttpSession customerSession;
	
    public static void setCustomerSession(HttpSession customerSession) {
    	ContextHolderUtils.customerSession = customerSession;
	}

	/**
     * SpringMvc下获取request
     * 
     * @return
     */
    public static HttpServletRequest getRequest() {
        ServletRequestAttributes requestAttributes = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()) ;
        if(requestAttributes!=null){
        	return requestAttributes.getRequest();
        }
        return null;
    }

    /**
     * SpringMvc下获取session
     * 
     * @return
     */
    public static HttpSession getSession() {
        HttpSession session = null;
        if(getRequest() != null){
            session = getRequest().getSession();
        }
        if(session == null) {
        	if(ContextHolderUtils.customerSession != null) {
        		return ContextHolderUtils.customerSession;
        	} else {
            	throw new BusinessException("未设置Session，请手动设置Session");
            }
        }
        return session;
    }

}
