package com.biz.eisp.base.common.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletResponse;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JsonUtil {
	private static final Logger logger = Logger.getLogger(JsonUtil.class);
	private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

	public static void object2Json(Class<?> clazz, Object object,
			List<String> parameters, Boolean flag,PrintWriter pw) {
		 pw = null;
		try {
			//pw = ServletActionContext.getResponse().getWriter();

			StringBuffer json = null;

			if (flag.booleanValue())
				json = new StringBuffer("{object: [");
			else
				json = new StringBuffer("[");
			Iterator localIterator1;
			if (Collection.class.isAssignableFrom(clazz)) {
				int count = 0;
				for (localIterator1 = ((List) object).iterator(); localIterator1
						.hasNext();) {
					Object value = localIterator1.next();
					if (count++ != 0)
						json.append(",");
					json.append("{");
					int num = 0;
					for (String parameter : parameters) {
						if (num++ != 0)
							json.append(",");
						json.append(parameter);

						Boolean type = Boolean.valueOf(Boolean.class
								.equals(value.getClass().getMethod(
										"get"
												+ parameter.substring(0, 1)
														.toUpperCase()
												+ parameter.substring(1),
										new Class[0]).getReturnType()));

						if (type.booleanValue())
							json.append(": ");
						else {
							json.append(": '");
						}

						json.append(convert(value.getClass().getMethod(
								"get" + parameter.substring(0, 1).toUpperCase()
										+ parameter.substring(1), new Class[0])
								.invoke(value, new Object[0])));

						if (!type.booleanValue()) {
							json.append("'");
						}
					}
					json.append("}");
				}
			} else {
				json.append("{");
				int num = 0;
				for (String parameter : parameters) {
					if (num++ != 0)
						json.append(",");
					json.append(parameter);
					json.append(": '");
					json.append(convert(object.getClass().getMethod(
							"get" + parameter.substring(0, 1).toUpperCase()
									+ parameter.substring(1), new Class[0])
							.invoke(object, new Object[0])));

					json.append("'");
				}
				json.append("}");
			}

			if (flag.booleanValue())
				json.append("]}");
			else {
				json.append("]");
			}
			logger.info("json:" + json.toString());
			pw.print(json.toString());
			pw.close();
		} catch (Exception e) {
			logger.error(e);
		} finally {
			if (pw != null) {
				pw.flush();
				pw.close();
				pw = null;
			}
		}
	}

	private static String convert(Object str) {
		if (str == null) {
			return (String) str;
		}
		// return new String(str.toString().getBytes("UTF-8"), "ISO8859-1");
		return new String(str.toString());
	}
	
	public static String object2json(Object obj) {
		StringBuilder json = new StringBuilder();
		if (obj == null) {
			json.append("\"\"");
		} else if (obj instanceof String || obj instanceof Integer
				|| obj instanceof Float || obj instanceof Boolean
				|| obj instanceof Short || obj instanceof Double
				|| obj instanceof Long || obj instanceof BigDecimal
				|| obj instanceof BigInteger || obj instanceof Byte) {
			json.append("\"").append(string2json(obj.toString())).append("\"");
		} else if (obj instanceof Object[]) {
			json.append(array2json((Object[]) obj));
		} else if (obj instanceof List) {
			json.append(list2json((List<?>) obj));
		} else if (obj instanceof Map) {
			json.append(map2json((Map<?, ?>) obj));
		} else if (obj instanceof Set) {
			json.append(set2json((Set<?>) obj));
		} else {
			json.append(bean2json(obj));
		}
		return json.toString();
	}

	public static String bean2json(Object bean) {
		StringBuilder json = new StringBuilder();
		json.append("{");
		PropertyDescriptor[] props = null;
		try {
			props = Introspector.getBeanInfo(bean.getClass(), Object.class)
					.getPropertyDescriptors();
		} catch (IntrospectionException e) {
		}
		if (props != null) {
			for (int i = 0; i < props.length; i++) {
				try {
					String name = object2json(props[i].getName());
					String value = object2json(props[i].getReadMethod().invoke(
							bean));
					json.append(name);
					json.append(":");
					json.append(value);
					json.append(",");
				} catch (Exception e) {
				}
			}
			json.setCharAt(json.length() - 1, '}');
		} else {
			json.append("}");
		}
		return json.toString();
	}

	public static String list2json(List<?> list) {
		StringBuilder json = new StringBuilder();
		json.append("[");
		if (list != null && list.size() > 0) {
			for (Object obj : list) {
				json.append(object2json(obj));
				json.append(",");
			}
			json.setCharAt(json.length() - 1, ']');
		} else {
			json.append("]");
		}
		return json.toString();
	}

	public static String array2json(Object[] array) {
		StringBuilder json = new StringBuilder();
		json.append("[");
		if (array != null && array.length > 0) {
			for (Object obj : array) {
				json.append(object2json(obj));
				json.append(",");
			}
			json.setCharAt(json.length() - 1, ']');
		} else {
			json.append("]");
		}
		return json.toString();
	}

	public static String map2json(Map<?, ?> map) {
		StringBuilder json = new StringBuilder();
		json.append("{");
		if (map != null && map.size() > 0) {
			for (Object key : map.keySet()) {
				json.append(object2json(key));
				json.append(":");
				json.append(object2json(map.get(key)));
				json.append(",");
			}
			json.setCharAt(json.length() - 1, '}');
		} else {
			json.append("}");
		}
		return json.toString();
	}

	public static String set2json(Set<?> set) {
		StringBuilder json = new StringBuilder();
		json.append("[");
		if (set != null && set.size() > 0) {
			for (Object obj : set) {
				json.append(object2json(obj));
				json.append(",");
			}
			json.setCharAt(json.length() - 1, ']');
		} else {
			json.append("]");
		}
		return json.toString();
	}

	public static String string2json(String s) {
		if (s == null)
			return "";
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < s.length(); i++) {
			char ch = s.charAt(i);
			switch (ch) {
			case '"':
				sb.append("\\\"");
				break;
			case '\\':
				sb.append("\\\\");
				break;
			case '\b':
				sb.append("\\b");
				break;
			case '\f':
				sb.append("\\f");
				break;
			case '\n':
				sb.append("\\n");
				break;
			case '\r':
				sb.append("\\r");
				break;
			case '\t':
				sb.append("\\t");
				break;
			case '/':
				sb.append("\\/");
				break;
			default:
				if (ch >= '\u0000' && ch <= '\u001F') {
					String ss = Integer.toHexString(ch);
					sb.append("\\u");
					for (int k = 0; k < 4 - ss.length(); k++) {
						sb.append('0');
					}
					sb.append(ss.toUpperCase());
				} else {
					sb.append(ch);
				}
			}
		}
		return sb.toString();
	}
	
	public static void outPrintJson(HttpServletResponse response,String strJson){
		response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
		response.setCharacterEncoding("UTF-8");
		try {
			PrintWriter out = response.getWriter();
			out.print(strJson);
			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
        
	}

	public static <T> T json2Obj(String content,Class<T> clazzItem, Class ... classes) {
		if (StringUtils.isBlank(content)) {
			return null;
		}
		JavaType javaType  = OBJECT_MAPPER.getTypeFactory().constructParametricType(clazzItem, classes);
		try {
			return OBJECT_MAPPER.readValue(content, javaType);
		} catch (Exception e) {
			throw new RuntimeException("Json反序列化出错", e);
		}
	}
	
}