package com.biz.eisp.base.common.util;

import org.apache.commons.lang.StringUtils;

/**
 * 编码生成器
 */
public final class RandomGeneratorCodeUtils {
    private volatile static SnowflakeIdWorker snowflakeIdWorker = null;

    private RandomGeneratorCodeUtils() {}

    /**
     * 生成唯一性编码CODE
     * @param prefixMark 前缀标识
     * @return
     */
    public static String code(final String prefixMark) {
        return code(prefixMark, 0, 1);
    }

    /**
     * 生成唯一性编码CODE
     * @Title: code
     * @param prefixMark 前缀标识
     * @param markCode 机器标志码(主要为了以后的集群)
     * @param projectMarkCode 项目标识码(主要分区项目)
     * @return 自动生成
     * @author: Omar(OmarZhang)
     * @date: 2016年5月22日 下午4:04:50
     */
    public static synchronized String code(final String prefixMark, final int markCode, final int projectMarkCode) {
        if (snowflakeIdWorker == null) {
            snowflakeIdWorker = new SnowflakeIdWorker(markCode, projectMarkCode);
        }

        if (StringUtils.isNotBlank(prefixMark)) {
            return prefixMark.concat(String.valueOf(snowflakeIdWorker.nextId()));
        }

        return String.valueOf(snowflakeIdWorker.nextId());
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
