package com.biz.eisp.base.common.validation;

import java.util.ArrayList;
import java.util.List;

import com.biz.eisp.base.common.util.CollectionUtil;

/**
 * 数据验证
 * 
 * @author liukai
 * 
 */
public class Validation {

	private List<ValidationMessage> ValidationMessageList; // 验证信息列表

	private List<ValidationStrategy> validationStrategyList; // 策略列表
	
	private boolean isCumulative=true ;//遇到错误是否累积

	public Validation() {
		validationStrategyList = new ArrayList<ValidationStrategy>(); // 初始化策略信息列表
		ValidationMessageList = new ArrayList<ValidationMessage>(); // 初始化验证信息列表
	}

	/**
	 * 初始化验证信息
	 */
	public void init() {
		validationStrategyList = new ArrayList<ValidationStrategy>(); // 初始化策略信息列表
		ValidationMessageList = new ArrayList<ValidationMessage>(); // 初始化验证信息列表
	}

	/**
	 * 获取验证信息列表
	 * 
	 * @return
	 */
	public List<ValidationMessage> getValidationMessageList() {
		return ValidationMessageList;
	}

	/**
	 * 注册策略
	 * 
	 * @param vs
	 */
	public void regiesterStrategy(ValidationStrategy validationStrategy) {
		validationStrategyList.add(validationStrategy);
	}

	/**
	 * 进行数据验证
	 */
	public void validate() {
		if (validationStrategyList != null && validationStrategyList.size() > 0) {
			for (ValidationStrategy vd : validationStrategyList) {
				ValidationMessage vm = vd.validate();
				if (vm != null) {
					ValidationMessageList.add(vm);
					if(!vm.isSuccess()&&!isCumulative()){
						break;
					}
				}
			}
		}
	}

	/**
	 * 获取数据验证情况 true验证成功 false 验证失败
	 * 
	 * @return
	 */
	public boolean isValid() {
		boolean success = true;
		if (ValidationMessageList != null && ValidationMessageList.size() > 0) {
			for (ValidationMessage vm : ValidationMessageList) {
				if (!vm.isSuccess()) {
					success = vm.isSuccess();
					break;
				}
			}
		}
		return success;
	}

	/**
	 * 添加验证信息
	 * 
	 * @param vm
	 */
	public void addValidationMessage(ValidationMessage vm) {
		ValidationMessageList.add(vm);
	}

	/**
	 * 添加成功信息
	 * 
	 * @param msg
	 */
	public void addSuccessMessage(String msg) {
		ValidationMessage vm = new ValidationMessage();
		vm.setSuccess(true);
		vm.setMessage(msg);
		ValidationMessageList.add(vm);
	}
	/**
	 * 获取验证信息字符串.
	 * @author grover
	 * 
	 * @return
	 */
	public String getValidatinMessage() {
		String msg = "";
		if(CollectionUtil.collectionNotEmpty(ValidationMessageList)){
			for (ValidationMessage validationMessage : ValidationMessageList) {
				msg += validationMessage.getMessage()+"<br>";
			}
		}
		return msg;
	}
	
	public boolean isCumulative() {
		return isCumulative;
	}

	public void setCumulative(boolean isCumulative) {
		this.isCumulative = isCumulative;
	}
	
	
}