package com.biz.eisp.base.common.validation;

import org.apache.commons.collections.CollectionUtils;

import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import java.util.Set;

/**
 * 验证实体工具类.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public class ValidationUtils {

	private static Validator validator = javax.validation.Validation.buildDefaultValidatorFactory().getValidator();

	public static <T> ValidationMessage validateEntity(T obj) {
		ValidationMessage result = new ValidationMessage();
		Set<ConstraintViolation<T>> set = validator.validate(obj, Default.class);
		if (CollectionUtils.isNotEmpty(set)) {
			result.setSuccess(false);
			StringBuffer errorMsg = new StringBuffer();
			for (ConstraintViolation<T> cv : set) {
				errorMsg.append(cv.getMessage());
			}
			result.setMessage(errorMsg.toString());
		} else {
			result.setSuccess(true);
		}
		return result;
	}

	public static <T> ValidationMessage validateProperty(T obj, String propertyName) {
		ValidationMessage result = new ValidationMessage();
		Set<ConstraintViolation<T>> set = validator.validateProperty(obj, propertyName, Default.class);
		if (CollectionUtils.isNotEmpty(set)) {
			result.setSuccess(false);
			StringBuffer errorMsg = new StringBuffer();
			for (ConstraintViolation<T> cv : set) {
				errorMsg.append(cv.getMessage());
			}
			result.setMessage(errorMsg.toString());
		} else {
			result.setSuccess(true);
		}
		return result;
	}
}
