package com.biz.eisp.base.converter;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.common.exception.BusinessException;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

import javax.persistence.AttributeConverter;
import java.lang.reflect.ParameterizedType;
import java.util.List;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/4/18
 */
public abstract class BaseJsonArrayConverter<E> implements AttributeConverter<List<E>,String> {

    private Class<E> clz;

    public BaseJsonArrayConverter() {
        try {
            clz = (Class<E>) ((ParameterizedType) this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        } catch (Exception e) {
            throw new BusinessException("反射失败", e);
        }
    }

    @Override
    public String convertToDatabaseColumn(List<E> attribute) {
        return JSONArray.toJSONString(attribute);
    }

    @Override
    public List<E> convertToEntityAttribute(String dbData) {
        if (StringUtils.isNotEmpty(dbData)){
            try {
                return JSONArray.parseArray(dbData,clz);
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return Lists.newArrayList();
    }
}
