package com.biz.eisp.base.converter;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.exception.BusinessException;
import org.apache.commons.lang.StringUtils;

import javax.persistence.AttributeConverter;
import java.lang.reflect.ParameterizedType;

/**
 * 将对象以json字符串保存到数据库，转换器
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/4/18
 */
public abstract class BaseJsonObjectConverter<E> implements AttributeConverter<E,String>{

    private Class<E> clz;

    public BaseJsonObjectConverter() {
        try {
            clz = (Class<E>) ((ParameterizedType) this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        } catch (Exception e) {
            throw new BusinessException("反射失败", e);
        }
    }

    @Override
    public String convertToDatabaseColumn(E attribute) {
        return JSONObject.toJSONString(attribute);
    }

    @Override
    public E convertToEntityAttribute(String dbData) {
        if (StringUtils.isNotEmpty(dbData)){
            try {
                return JSONObject.parseObject(dbData,clz);
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return null;
    }
}
