package com.biz.eisp.base.converter;

import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/4/18
 */
public interface ListBaseTypeConverter {

    class ListStringConverter extends AbstractListBaseTypeConverter<String>{
        @Override
        protected String toSystemObject(String attributeString) {
            return attributeString;
        }

        @Override
        protected String toDBAttributeString(String attribute) {
            return attribute;
        }
    }

    class ListIntegerConverter extends AbstractListBaseTypeConverter<Integer>{
        @Override
        protected Integer toSystemObject(String attributeString) {
            return StringUtils.isNotEmpty(attributeString)?Integer.parseInt(attributeString):null;
        }

        @Override
        protected String toDBAttributeString(Integer attribute) {
            return attribute==null?null:attribute.toString();
        }
    }

    class ListLongConverter extends AbstractListBaseTypeConverter<Long>{

        @Override
        protected Long toSystemObject(String attributeString) {
            return StringUtils.isNotEmpty(attributeString)?Long.parseLong(attributeString):null;
        }

        @Override
        protected String toDBAttributeString(Long attribute) {
            return attribute==null?null:attribute.toString();
        }
    }

    class ListDoubleConverter extends AbstractListBaseTypeConverter<Double>{

        @Override
        protected Double toSystemObject(String attributeString) {
            return StringUtils.isNotEmpty(attributeString)?Double.parseDouble(attributeString):null;
        }

        @Override
        protected String toDBAttributeString(Double attribute) {
            return attribute==null?null:attribute.toString();
        }
    }

    class ListDateConverter extends AbstractListBaseTypeConverter<Date>{

        @Override
        protected Date toSystemObject(String attributeString) {
            return StringUtils.isNotEmpty(attributeString)?new Date(Long.parseLong(attributeString)):null;
        }

        @Override
        protected String toDBAttributeString(Date attribute) {
            return attribute==null?null:String.valueOf(attribute.getTime());
        }
    }

    class ListTimeConverter extends AbstractListBaseTypeConverter<Time>{

        @Override
        protected Time toSystemObject(String attributeString) {
            return StringUtils.isNotEmpty(attributeString)?new Time(Long.parseLong(attributeString)):null;
        }

        @Override
        protected String toDBAttributeString(Time attribute) {
            return attribute==null?null:String.valueOf(attribute.getTime());
        }
    }

    class ListBigDecimalConverter extends AbstractListBaseTypeConverter<BigDecimal>{

        @Override
        protected BigDecimal toSystemObject(String attributeString) {
            return new BigDecimal(attributeString);
        }

        @Override
        protected String toDBAttributeString(BigDecimal attribute) {
            return attribute.toString();
        }
    }
}
