package com.biz.eisp.base.core.dao;

import javax.servlet.http.HttpSession;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.biz.eisp.base.utils.ApplicationContextUtils;

/**
 * @author liukai
 *
 */
public class HibernatePersister extends HibernateBaseDao {
	
	public static final String DEFAULT_SESSION_FACTORY_NAME = "sessionFactory";
	private Session session;
	private Transaction tx;
	
	public HibernatePersister() {
		this(DEFAULT_SESSION_FACTORY_NAME);
	}
	
	public HibernatePersister(HttpSession session) {
		this(DEFAULT_SESSION_FACTORY_NAME, session);
	}
	
	public HibernatePersister(String sessionFactoryName) {
		SessionFactory sessionFactory = (SessionFactory) ApplicationContextUtils.getContext().getBean(sessionFactoryName);
		super.setSessionFactory(sessionFactory);
		session = sessionFactory.openSession();
	}
	
	public HibernatePersister(String sessionFactoryName, HttpSession httpSession) {
		SessionFactory sessionFactory = (SessionFactory) ApplicationContextUtils.getContext().getBean(sessionFactoryName);
		super.setSessionFactory(sessionFactory);
		session = sessionFactory.openSession();
	}
	
	public HibernatePersister(String sessionFactoryName, String dataBaseName) {
		SessionFactory sessionFactory = (SessionFactory) ApplicationContextUtils.getContext().getBean(sessionFactoryName);
		super.setSessionFactory(sessionFactory);
		session = sessionFactory.openSession();
	}
	
	@Override
	public Session getSession() { 
		return session;
	}
	
	public void beginTransaction() {
		tx = session.beginTransaction();
	}

	public void commit() {
		tx.commit();
	}
	
	public void rollback() {
		if (tx != null) {
			tx.rollback();
			tx = null;
		}
	}
	
	public void close() {
		if (session != null) {
			session.close();
			session = null;
		}
	}

}
