package com.biz.eisp.base.core.interceptors;

import com.biz.eisp.base.common.constant.HibernateConstant;
import com.biz.eisp.rpc.AuthObjectRpcService;
import com.biz.eisp.rpc.ResourceRpcService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.Date;

/**
 * Hiberate拦截器：实现创建人，创建时间，创建人名称自动注入; 修改人,修改时间,修改人名自动注入;
 * 
 * @author liukai
 *
 */
@Component("hibernateEntityInterceptor")
public class HibernateEntityInterceptor extends EmptyInterceptor {
	
	private static final long serialVersionUID = 1L;

//	@Resource(name = "resourceRpcServiceImpl")
	@Autowired
	private ResourceRpcService resourceRpcService;

//	@Resource(name = "authObjectRpcServiceImpl")
	@Autowired
	private AuthObjectRpcService authObjectRpcService;

	@Override
	public boolean onSave(Object entity, Serializable id, Object[] state,String[] propertyNames, Type[] types) {
		String currentName = null;
		Subject subject = SecurityUtils.getSubject();
		if(subject != null) {
			Object principal = subject.getPrincipal();
			currentName = (String) principal;
		}
		for(int i = 0 ;i < propertyNames.length; i++) {
			 //设置创建时间
		     if (HibernateConstant.CREATE_DATE.equals(propertyNames[i])) {
		    	 if(isEmpty(state[i])){
		    		 state[i] = new Date();
		    	 }
		         continue;
		     } 
		     //设置创建用户账号
		     else if (HibernateConstant.CREATE_NAME.equals(propertyNames[i])) { 
		    	 if(isEmpty(state[i])) {
		    		  state[i] = currentName;
		    	 }
		         continue;
		     }
		     //设置修改时间
		     else if (HibernateConstant.UPDATE_DATE.equals(propertyNames[i])) { 
		    	 if(isEmpty(state[i])) {
		    		 state[i] = new Date();
		    	 }
		         continue;
		     }
		     //设置修改用户账号
		     else if (HibernateConstant.UPDATE_NAME.equals(propertyNames[i])) { 
		    	 if(isEmpty(state[i])) {
		    		  state[i] = currentName;
		    	 }
		         continue;
		     }
		     //设置创建用户主职位id
		     else if (HibernateConstant.CREATE_POS_ID.equals(propertyNames[i])) { 
		    	 if(isEmpty(state[i])) {
					 	if(currentName != null) {
							state[i] = resourceRpcService.getCurrPosition(currentName).getId();
						}
		    	 }
		    	 continue;
		     }
		}
		return true;
	}
	
	@Override
	public boolean onFlushDirty(Object entity,Serializable id,  Object[] currentState,
			Object[] previousState, String[] propertyNames,Type[] types) {

		String currentName = null;
		Subject subject = SecurityUtils.getSubject();
		if(subject != null) {
			Object principal = subject.getPrincipal();
			currentName = (String) principal;
		}

		for(int i=0;i<propertyNames.length;i++){
		     //设置修改时间
			if (HibernateConstant.UPDATE_DATE.equals(propertyNames[i])) { 
		    	 currentState[i] = new Date();
		         continue;
		     }
		     //设置修改用户
		     else if (HibernateConstant.UPDATE_NAME.equals(propertyNames[i])) { 
		    	 currentState[i] = currentName;
		         continue;
		     }
			 //设置修改人主职位id
		     else if (HibernateConstant.UPDATE_POS_ID.equals(propertyNames[i])) {
						if(currentName != null) {
							currentState[i] = resourceRpcService.getCurrPosition(currentName).getId();
						}
	    		 continue;
		     }
		}
        return true;
    }
	
	/**
	 * 判断object是否为空
	 * @param object
	 * @return
	 */
	public boolean isEmpty(Object object) {
		if (object == null||object.equals("")||object.equals("null")) {
			return (true);
		}
		return (false);
	}
	
	@Override
	public String onPrepareStatement(String sql) {
		//权限对象判定
		return authObjectRpcService.executeAuthHandle(sql);
	}
	
}

