package com.biz.eisp.base.core.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.BrowserUtils;
import com.biz.eisp.base.core.interceptors.PageInterceptor;
import com.biz.eisp.base.core.web.converter.DateEditor;
import com.biz.eisp.base.exporter.ExcelExportUtil;
import com.biz.eisp.base.exporter.entity.ExcelTitle;
import com.biz.eisp.page.Page;
import com.biz.eisp.rpc.ResourceRpcService;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.List;


/**
 * <p>
 * 基础控制器
 * </p>
 * <br>
 * 其他所有控制器都应该继承于它。 它提供控制器通用功能：
 * <li>其他控制器需集成此控制器获得initBinder自动转换的功能</li>
 * 
 * @author liukai
 */
@Controller
@RequestMapping("/baseController")
public class BaseController {

	protected String message="操作成功";
	protected boolean success=true;

//	@Resource(name = "resourceRpcServiceImpl")
	@Autowired
	private ResourceRpcService resourceRpcService;
	
	/**
	 * 页面对象page，
	 */
	protected Page page;

	public BaseController() {
		page = PageInterceptor.getPage(); //设置Page对象值，通过页面拦截器对象来设值
	}
	
	/**
	 * 将前台传递过来的日期格式的字符串，自动转化为Date类型
	 * @param binder
	 */
	@InitBinder
	public void initBinder(ServletRequestDataBinder binder) {
		binder.registerCustomEditor(Date.class, new DateEditor());
	}

	public String getCurrentName() {
		Subject subject = SecurityUtils.getSubject();
		String name = null;
		if(subject != null) {
			Object principal = subject.getPrincipal();
			name = (String) principal;
		}
		return name;
	}
	
	
	/**
	 * datagrid返回
	 * @param response Response对象
	 * @param list 发送给web端datagrid的数据
	 */
	public void datagridReturn(HttpServletResponse response,List list,Page pg){
		JSONObject json=new JSONObject();
		json.put("success", success);
		json.put("pages",pg.get(Page.PAGE));
		json.put("total", pg.get(Page.TOTAL));
		json.put("rows",list);
		this.doSend(response, json.toJSONString());
	}
	
	/**
	 * datagrid返回
	 * @param response Response对象
	 * @param list 发送给web端datagrid的数据
	 */
	public void datagridReturn(HttpServletResponse response,List list){
		JSONObject json=new JSONObject();
		json.put("success", success);
		json.put("total", 0);
		json.put("rows",list);
		this.doSend(response, json.toJSONString());
	}
	
	/**
	 * 自定义请求处理结果
	 * @param response Response对象
	 * @param json JSON对象
	 */
	public void sendResponseJson(HttpServletResponse response,JSONObject json){
		this.doSend(response, json.toJSONString());
	}
	
	/**
	 * message返回
	 * @param response Response对象
	 */
	public void sendResponse(HttpServletResponse response){
		JSONObject json=new JSONObject();
		json.put("success", success);
		json.put("msg",message);
		this.doSend(response, json.toJSONString());
	}
	
	/**
	 * 请求处理成功
	 * @param response Response对象
	 */
	public void sendResponseObj(HttpServletResponse response,Object obj){
		
		this.doSend(response,  JSON.toJSONString( obj, true));
	}
	
	/**
	 * 请求处理成功
	 * @param response Response对象
	 */
	public void sendObjToJSON(HttpServletResponse response,Object obj){
		JSONObject json=new JSONObject();
		json.put("success", success);
		json.put("msg",message);
		json.put("obj", obj);
		this.doSend(response, json.toJSONString());
	}
	
	/**
	 * 请求处理成功
	 * @param response Response对象
	 */
	public void sendResponseState(HttpServletResponse response,boolean success,Object obj){
		JSONObject json=new JSONObject();
		json.put("success", success);
		json.put("msg",message);
		json.put("obj", obj);
		this.doSend(response, json.toJSONString());
	}
	
	/**
	 * 返回处理结果
	 * @return json对象
	 */
	public JSONObject returnJson(){
		JSONObject json=new JSONObject();
		json.put("success", success);
		json.put("msg",message);
		return json;
	}
	
	/**
	 * 返回处理结果
	 * @return json 字符串
	 */
	public String returnJsonString(){
		return returnJson().toJSONString();
	}
	
	/**
	 * 返回处理结果
	 * @return json对象
	 */
	public JSONObject returnJson(Object obj){
		JSONObject json=new JSONObject();
		json.put("success", success);
		json.put("msg",message);
		json.put("obj",obj);
		return json;
	}
	
	/**
	 * 返回处理结果
	 * @param json  json对象
	 * @return json对象
	 */
	public JSONObject returnJson(JSONObject json){
		json.put("success", true);
		json.put("msg",message);
		return json;
	}
	
	
	/**
	 * 发送处理结果
	 * @param response response Response对象
	 * @param json JSON字符串
	 */
	private void doSend(HttpServletResponse response,String json){
	    response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
		PrintWriter pw = null;
		try {
			pw=response.getWriter();
			pw.write(json);
			pw.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			try {
				json="";
				message="操作成功";
				pw.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * 导出数据
	 * @param <T>
	 * @param response
	 * @param request
	 * @param title 导出标题
	 */
	protected <T> void doExportXls(HttpServletResponse response, 
						HttpServletRequest request, Collection<?> dataSet,Class<?> pojoClass, String title) {
		
		response.setContentType("application/vnd.ms-excel");
		OutputStream fOut = null;
		try {
			// 根据浏览器进行转码，使其支持中文文件名
			if (BrowserUtils.isIE(request)) {
				response.setHeader("content-disposition",
						"attachment;filename=" + java.net.URLEncoder.encode(title, "UTF-8") + ".xls");
			}
			else {
				String newtitle = new String(title.getBytes("UTF-8"), "ISO8859-1");
				response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
			}
			// 产生工作簿对象
			HSSFWorkbook workbook = null;
            ExcelTitle excelTitle = new ExcelTitle(title, "导出人:" + resourceRpcService.getSessionUserName().getFullName(), "导出信息");
            workbook = ExcelExportUtil.exportExcel(excelTitle,pojoClass,dataSet);
			fOut = response.getOutputStream();
			workbook.write(fOut);
		} 
		catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("导出失败！");
		} finally {
			try {
				if(fOut != null){
					fOut.flush();
					fOut.close();
				}
			}
			catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	@ExceptionHandler
	public void exceptionHandler(Exception e,HttpServletRequest request,HttpServletResponse response){

		e.printStackTrace();
		JSONObject json=new JSONObject();
		json.put("success", false);
		if(e instanceof BusinessException){

			json.put("msg",((BusinessException)e).getMessage());
		}else{

			json.put("msg",e.getMessage());
		}
		this.doSend(response, json.toJSONString());
	}

}
